/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.security.ServerAuthException;
import org.apache.storm.shade.org.eclipse.jetty.security.UserAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.apache.storm.shade.org.eclipse.jetty.server.Authentication;
import org.apache.storm.shade.org.eclipse.jetty.server.UserIdentity;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);
    private String _authMethod = "SPNEGO";

    public SpnegoAuthenticator() {
    }

    public SpnegoAuthenticator(String authMethod) {
        this._authMethod = authMethod;
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response2, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response2;
        String header2 = req.getHeader("Authorization");
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        if (header2 == null) {
            try {
                if (DeferredAuthentication.isDeferred(res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                LOG.debug("SpengoAuthenticator: sending challenge", new Object[0]);
                res.setHeader("WWW-Authenticate", "Negotiate");
                res.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException ioe) {
                throw new ServerAuthException(ioe);
            }
        }
        if (header2 != null && header2.startsWith("Negotiate") && (user = this._loginService.login(null, spnegoToken = header2.substring(10))) != null) {
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response2, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

