/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.storm.shade.org.eclipse.jetty.security.Authenticator;
import org.apache.storm.shade.org.eclipse.jetty.security.ServerAuthException;
import org.apache.storm.shade.org.eclipse.jetty.security.UserAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.server.AbstractHttpConnection;
import org.apache.storm.shade.org.eclipse.jetty.server.Authentication;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.UserIdentity;
import org.apache.storm.shade.org.eclipse.jetty.util.MultiMap;
import org.apache.storm.shade.org.eclipse.jetty.util.StringUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.apache.storm.shade.org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.apache.storm.shade.org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.apache.storm.shade.org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.apache.storm.shade.org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.apache.storm.shade.org.eclipse.jetty.security.form_POST";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;
    private boolean _alwaysSaveUri;

    public FormAuthenticator() {
    }

    public FormAuthenticator(String login, String error2, boolean dispatch) {
        this();
        if (login != null) {
            this.setLoginPage(login);
        }
        if (error2 != null) {
            this.setErrorPage(error2);
        }
        this._dispatch = dispatch;
    }

    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    public boolean getAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        String dispatch;
        String error2;
        super.setConfiguration(configuration);
        String login = configuration.getInitParameter(__FORM_LOGIN_PAGE);
        if (login != null) {
            this.setLoginPage(login);
        }
        if ((error2 = configuration.getInitParameter(__FORM_ERROR_PAGE)) != null) {
            this.setErrorPage(error2);
        }
        this._dispatch = (dispatch = configuration.getInitParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.valueOf(dispatch);
    }

    public String getAuthMethod() {
        return "FORM";
    }

    private void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                LOG.warn("form-error-page must start with /", new Object[0]);
                path = "/" + path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response2 = (HttpServletResponse)res;
        String uri = request.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        if (!(mandatory |= this.isJSecurityCheck(uri))) {
            return new DeferredAuthentication(this);
        }
        if (this.isLoginOrErrorPage(URIUtil.addPaths(request.getServletPath(), request.getPathInfo())) && !DeferredAuthentication.isDeferred(response2)) {
            return new DeferredAuthentication(this);
        }
        HttpSession session2 = request.getSession(true);
        try {
            if (this.isJSecurityCheck(uri)) {
                String password;
                String username = request.getParameter(__J_USERNAME);
                UserIdentity user = this._loginService.login(username, password = request.getParameter(__J_PASSWORD));
                if (user != null) {
                    String nuri;
                    HttpSession httpSession = session2 = this.renewSession(request, response2);
                    synchronized (httpSession) {
                        nuri = (String)session2.getAttribute(__J_URI);
                        if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                            nuri = "/";
                        }
                        SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
                        session2.setAttribute("org.apache.storm.shade.org.eclipse.jetty.security.UserIdentity", (Object)cached);
                    }
                    response2.setContentLength(0);
                    response2.sendRedirect(response2.encodeRedirectURL(nuri));
                    return new FormAuthentication(this.getAuthMethod(), user);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable(username), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    if (response2 != null) {
                        response2.sendError(403);
                    }
                } else if (this._dispatch) {
                    RequestDispatcher dispatcher = request.getRequestDispatcher(this._formErrorPage);
                    response2.setHeader("Cache-Control", "No-cache");
                    response2.setDateHeader("Expires", 1L);
                    dispatcher.forward((ServletRequest)new FormRequest(request), (ServletResponse)new FormResponse(response2));
                } else {
                    response2.sendRedirect(response2.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formErrorPage)));
                }
                return Authentication.SEND_FAILURE;
            }
            Authentication authentication = (Authentication)session2.getAttribute("org.apache.storm.shade.org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    session2.removeAttribute("org.apache.storm.shade.org.eclipse.jetty.security.UserIdentity");
                } else {
                    String j_uri = (String)session2.getAttribute(__J_URI);
                    if (j_uri != null) {
                        MultiMap j_post = (MultiMap)session2.getAttribute(__J_POST);
                        if (j_post != null) {
                            StringBuffer buf = request.getRequestURL();
                            if (request.getQueryString() != null) {
                                buf.append("?").append(request.getQueryString());
                            }
                            if (j_uri.equals(buf.toString())) {
                                session2.removeAttribute(__J_POST);
                                Request base_request = req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
                                base_request.setMethod("POST");
                                base_request.setParameters(j_post);
                            }
                        } else {
                            session2.removeAttribute(__J_URI);
                        }
                    }
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred(response2)) {
                LOG.debug("auth deferred {}", session2.getId());
                return Authentication.UNAUTHENTICATED;
            }
            HttpSession j_uri = session2;
            synchronized (j_uri) {
                if (session2.getAttribute(__J_URI) == null || this._alwaysSaveUri) {
                    StringBuffer buf = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        buf.append("?").append(request.getQueryString());
                    }
                    session2.setAttribute(__J_URI, (Object)buf.toString());
                    if ("application/x-www-form-urlencoded".equalsIgnoreCase(req.getContentType()) && "POST".equals(request.getMethod())) {
                        Request base_request = req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
                        base_request.extractParameters();
                        session2.setAttribute(__J_POST, new MultiMap<String>(base_request.getParameters()));
                    }
                }
            }
            if (this._dispatch) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(this._formLoginPage);
                response2.setHeader("Cache-Control", "No-cache");
                response2.setDateHeader("Expires", 1L);
                dispatcher.forward((ServletRequest)new FormRequest(request), (ServletResponse)new FormResponse(response2));
            } else {
                response2.sendRedirect(response2.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formLoginPage)));
            }
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
        catch (ServletException e) {
            throw new ServerAuthException(e);
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public static class FormAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public FormAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "Form" + super.toString();
        }
    }

    protected static class FormResponse
    extends HttpServletResponseWrapper {
        public FormResponse(HttpServletResponse response2) {
            super(response2);
        }

        public void addDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                super.addDateHeader(name, date);
            }
        }

        public void addHeader(String name, String value) {
            if (this.notIgnored(name)) {
                super.addHeader(name, value);
            }
        }

        public void setDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                super.setDateHeader(name, date);
            }
        }

        public void setHeader(String name, String value) {
            if (this.notIgnored(name)) {
                super.setHeader(name, value);
            }
        }

        private boolean notIgnored(String name) {
            return !"Cache-Control".equalsIgnoreCase(name) && !"Pragma".equalsIgnoreCase(name) && !"ETag".equalsIgnoreCase(name) && !"Expires".equalsIgnoreCase(name) && !"Last-Modified".equalsIgnoreCase(name) && !"Age".equalsIgnoreCase(name);
        }
    }

    protected static class FormRequest
    extends HttpServletRequestWrapper {
        public FormRequest(HttpServletRequest request) {
            super(request);
        }

        public long getDateHeader(String name) {
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return -1L;
            }
            return super.getDateHeader(name);
        }

        public String getHeader(String name) {
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return null;
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            return Collections.enumeration(Collections.list(super.getHeaderNames()));
        }

        public Enumeration getHeaders(String name) {
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return super.getHeaders(name);
        }
    }
}

