/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.security.ServerAuthException;
import org.apache.storm.shade.org.eclipse.jetty.security.UserAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.apache.storm.shade.org.eclipse.jetty.server.Authentication;
import org.apache.storm.shade.org.eclipse.jetty.server.UserIdentity;
import org.apache.storm.shade.org.eclipse.jetty.util.B64Code;

public class BasicAuthenticator
extends LoginAuthenticator {
    public String getAuthMethod() {
        return "BASIC";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response2 = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            String method;
            int space;
            if (!mandatory) {
                return new DeferredAuthentication(this);
            }
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
                String password;
                String username;
                UserIdentity user;
                credentials = credentials.substring(space + 1);
                int i = (credentials = B64Code.decode(credentials, "ISO-8859-1")).indexOf(58);
                if (i > 0 && (user = this._loginService.login(username = credentials.substring(0, i), password = credentials.substring(i + 1))) != null) {
                    this.renewSession(request, response2);
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (DeferredAuthentication.isDeferred(response2)) {
                return Authentication.UNAUTHENTICATED;
            }
            response2.setHeader("WWW-Authenticate", "basic realm=\"" + this._loginService.getName() + '\"');
            response2.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

