/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.storm.shade.org.eclipse.jetty.http.PathMap;
import org.apache.storm.shade.org.eclipse.jetty.security.ConstraintAware;
import org.apache.storm.shade.org.eclipse.jetty.security.ConstraintMapping;
import org.apache.storm.shade.org.eclipse.jetty.security.RoleInfo;
import org.apache.storm.shade.org.eclipse.jetty.security.SecurityHandler;
import org.apache.storm.shade.org.eclipse.jetty.security.UserDataConstraint;
import org.apache.storm.shade.org.eclipse.jetty.server.AbstractHttpConnection;
import org.apache.storm.shade.org.eclipse.jetty.server.Connector;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.Response;
import org.apache.storm.shade.org.eclipse.jetty.server.UserIdentity;
import org.apache.storm.shade.org.eclipse.jetty.util.StringMap;
import org.apache.storm.shade.org.eclipse.jetty.util.TypeUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.security.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private final PathMap _constraintMap = new PathMap();
    private boolean _strict = true;

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    @Override
    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getRoles() {
        return this._roles;
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        this.setConstraintMappings(constraintMappings, null);
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        this.setConstraintMappings(Arrays.asList(constraintMappings), null);
    }

    @Override
    public void setConstraintMappings(List<ConstraintMapping> constraintMappings, Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._constraintMappings.clear();
        this._constraintMappings.addAll(constraintMappings);
        if (roles == null) {
            roles = new HashSet<String>();
            for (ConstraintMapping cm : constraintMappings) {
                String[] cmr = cm.getConstraint().getRoles();
                if (cmr == null) continue;
                for (String r : cmr) {
                    if ("*".equals(r)) continue;
                    roles.add(r);
                }
            }
        }
        this.setRoles(roles);
    }

    public void setRoles(Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._roles.clear();
        this._roles.addAll(roles);
    }

    @Override
    public void addConstraintMapping(ConstraintMapping mapping) {
        this._constraintMappings.add(mapping);
        if (mapping.getConstraint() != null && mapping.getConstraint().getRoles() != null) {
            for (String role : mapping.getConstraint().getRoles()) {
                this.addRole(role);
            }
        }
        if (this.isStarted()) {
            this.processConstraintMapping(mapping);
        }
    }

    @Override
    public void addRole(String role) {
        boolean modified = this._roles.add(role);
        if (this.isStarted() && modified && this._strict) {
            for (Map map : this._constraintMap.values()) {
                for (RoleInfo info2 : map.values()) {
                    if (!info2.isAnyRole()) continue;
                    info2.addRole(role);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._constraintMap.clear();
        if (this._constraintMappings != null) {
            for (ConstraintMapping mapping : this._constraintMappings) {
                this.processConstraintMapping(mapping);
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._constraintMap.clear();
        this._constraintMappings.clear();
        this._roles.clear();
        super.doStop();
    }

    protected void processConstraintMapping(ConstraintMapping mapping) {
        RoleInfo allMethodsRoleInfo;
        Map mappings = (Map)this._constraintMap.get(mapping.getPathSpec());
        if (mappings == null) {
            mappings = new StringMap();
            this._constraintMap.put(mapping.getPathSpec(), mappings);
        }
        if ((allMethodsRoleInfo = (RoleInfo)mappings.get(null)) != null && allMethodsRoleInfo.isForbidden()) {
            return;
        }
        String httpMethod = mapping.getMethod();
        RoleInfo roleInfo = (RoleInfo)mappings.get(httpMethod);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            mappings.put(httpMethod, roleInfo);
            if (allMethodsRoleInfo != null) {
                roleInfo.combine(allMethodsRoleInfo);
            }
        }
        if (roleInfo.isForbidden()) {
            return;
        }
        Constraint constraint = mapping.getConstraint();
        boolean forbidden = constraint.isForbidden();
        roleInfo.setForbidden(forbidden);
        if (forbidden) {
            if (httpMethod == null) {
                mappings.clear();
                mappings.put(null, roleInfo);
            }
        } else {
            UserDataConstraint userDataConstraint = UserDataConstraint.get(constraint.getDataConstraint());
            roleInfo.setUserDataConstraint(userDataConstraint);
            boolean checked = constraint.getAuthenticate();
            roleInfo.setChecked(checked);
            if (roleInfo.isChecked()) {
                if (constraint.isAnyRole()) {
                    if (this._strict) {
                        for (String string : this._roles) {
                            roleInfo.addRole(string);
                        }
                    } else {
                        roleInfo.setAnyRole(true);
                    }
                } else {
                    String[] newRoles;
                    for (String role : newRoles = constraint.getRoles()) {
                        if (this._strict && !this._roles.contains(role)) {
                            throw new IllegalArgumentException("Attempt to use undeclared role: " + role + ", known roles: " + this._roles);
                        }
                        roleInfo.addRole(role);
                    }
                }
            }
            if (httpMethod == null) {
                for (Map.Entry entry : mappings.entrySet()) {
                    if (entry.getKey() == null) continue;
                    RoleInfo specific = (RoleInfo)entry.getValue();
                    specific.combine(roleInfo);
                }
            }
        }
    }

    @Override
    protected Object prepareConstraintInfo(String pathInContext, Request request) {
        Map mappings = (Map)this._constraintMap.match(pathInContext);
        if (mappings != null) {
            String httpMethod = request.getMethod();
            RoleInfo roleInfo = (RoleInfo)mappings.get(httpMethod);
            if (roleInfo == null) {
                roleInfo = (RoleInfo)mappings.get(null);
            }
            return roleInfo;
        }
        return null;
    }

    @Override
    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response2, Object constraintInfo) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (roleInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint dataConstraint = roleInfo.getUserDataConstraint();
        if (dataConstraint == null || dataConstraint == UserDataConstraint.None) {
            return true;
        }
        AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
        Connector connector = connection.getConnector();
        if (dataConstraint == UserDataConstraint.Integral) {
            if (connector.isIntegral(request)) {
                return true;
            }
            if (connector.getIntegralPort() > 0) {
                String url2;
                String scheme = connector.getIntegralScheme();
                int port = connector.getIntegralPort();
                String string = url2 = "https".equalsIgnoreCase(scheme) && port == 443 ? "https://" + request.getServerName() + request.getRequestURI() : scheme + "://" + request.getServerName() + ":" + port + request.getRequestURI();
                if (request.getQueryString() != null) {
                    url2 = url2 + "?" + request.getQueryString();
                }
                response2.setContentLength(0);
                response2.sendRedirect(url2);
            } else {
                response2.sendError(403, "!Integral");
            }
            request.setHandled(true);
            return false;
        }
        if (dataConstraint == UserDataConstraint.Confidential) {
            if (connector.isConfidential(request)) {
                return true;
            }
            if (connector.getConfidentialPort() > 0) {
                String url3;
                String scheme = connector.getConfidentialScheme();
                int port = connector.getConfidentialPort();
                String string = url3 = "https".equalsIgnoreCase(scheme) && port == 443 ? "https://" + request.getServerName() + request.getRequestURI() : scheme + "://" + request.getServerName() + ":" + port + request.getRequestURI();
                if (request.getQueryString() != null) {
                    url3 = url3 + "?" + request.getQueryString();
                }
                response2.setContentLength(0);
                response2.sendRedirect(url3);
            } else {
                response2.sendError(403, "!Confidential");
            }
            request.setHandled(true);
            return false;
        }
        throw new IllegalArgumentException("Invalid dataConstraint value: " + (Object)((Object)dataConstraint));
    }

    @Override
    protected boolean isAuthMandatory(Request baseRequest, Response base_response, Object constraintInfo) {
        if (constraintInfo == null) {
            return false;
        }
        return ((RoleInfo)constraintInfo).isChecked();
    }

    @Override
    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response2, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (!roleInfo.isChecked()) {
            return true;
        }
        if (roleInfo.isAnyRole() && request.getAuthType() != null) {
            return true;
        }
        for (String role : roleInfo.getRoles()) {
            if (!userIdentity.isUserInRole(role, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        ConstraintSecurityHandler.dump(out, indent, Collections.singleton(this.getLoginService()), Collections.singleton(this.getIdentityService()), Collections.singleton(this.getAuthenticator()), Collections.singleton(this._roles), this._constraintMap.entrySet(), this.getBeans(), TypeUtil.asList(this.getHandlers()));
    }
}

