/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.io.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.io.EndPoint;

public class StreamEndPoint
implements EndPoint {
    InputStream _in;
    OutputStream _out;
    int _maxIdleTime;
    boolean _ishut;
    boolean _oshut;

    public StreamEndPoint(InputStream in, OutputStream out) {
        this._in = in;
        this._out = out;
    }

    public boolean isBlocking() {
        return true;
    }

    public boolean blockReadable(long millisecs) throws IOException {
        return true;
    }

    public boolean blockWritable(long millisecs) throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this._in != null;
    }

    public final boolean isClosed() {
        return !this.isOpen();
    }

    public void shutdownOutput() throws IOException {
        this._oshut = true;
        if (this._ishut && this._out != null) {
            this._out.close();
        }
    }

    public boolean isInputShutdown() {
        return this._ishut;
    }

    public void shutdownInput() throws IOException {
        this._ishut = true;
        if (this._oshut && this._in != null) {
            this._in.close();
        }
    }

    public boolean isOutputShutdown() {
        return this._oshut;
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
        }
        this._in = null;
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
    }

    protected void idleExpired() throws IOException {
        if (this._in != null) {
            this._in.close();
        }
    }

    public int fill(Buffer buffer) throws IOException {
        if (this._ishut) {
            return -1;
        }
        if (this._in == null) {
            return 0;
        }
        int space = buffer.space();
        if (space <= 0) {
            if (buffer.hasContent()) {
                return 0;
            }
            throw new IOException("FULL");
        }
        try {
            int filled = buffer.readFrom(this._in, space);
            if (filled < 0) {
                this.shutdownInput();
            }
            return filled;
        }
        catch (SocketTimeoutException e) {
            this.idleExpired();
            return -1;
        }
    }

    public int flush(Buffer buffer) throws IOException {
        if (this._oshut) {
            return -1;
        }
        if (this._out == null) {
            return 0;
        }
        int length = buffer.length();
        if (length > 0) {
            buffer.writeTo(this._out);
        }
        if (!buffer.isImmutable()) {
            buffer.clear();
        }
        return length;
    }

    public int flush(Buffer header2, Buffer buffer, Buffer trailer) throws IOException {
        int f;
        int tw;
        int len = 0;
        if (header2 != null && (tw = header2.length()) > 0) {
            len = f = this.flush(header2);
            if (f < tw) {
                return len;
            }
        }
        if (buffer != null && (tw = buffer.length()) > 0) {
            f = this.flush(buffer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
            if (f < tw) {
                return len;
            }
        }
        if (trailer != null && (tw = trailer.length()) > 0) {
            f = this.flush(trailer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
        }
        return len;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalHost() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public Object getTransport() {
        return null;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    public void setInputStream(InputStream in) {
        this._in = in;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    public void flush() throws IOException {
        if (this._out != null) {
            this._out.flush();
        }
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

