/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.io;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.shade.org.eclipse.jetty.io.AbstractBuffers;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffers;

public class PooledBuffers
extends AbstractBuffers {
    private final Queue<Buffer> _headers;
    private final Queue<Buffer> _buffers;
    private final Queue<Buffer> _others;
    private final AtomicInteger _size = new AtomicInteger();
    private final int _maxSize;
    private final boolean _otherHeaders;
    private final boolean _otherBuffers;

    public PooledBuffers(Buffers.Type headerType, int headerSize, Buffers.Type bufferType, int bufferSize, Buffers.Type otherType, int maxSize) {
        super(headerType, headerSize, bufferType, bufferSize, otherType);
        this._headers = new ConcurrentLinkedQueue<Buffer>();
        this._buffers = new ConcurrentLinkedQueue<Buffer>();
        this._others = new ConcurrentLinkedQueue<Buffer>();
        this._otherHeaders = headerType == otherType;
        this._otherBuffers = bufferType == otherType;
        this._maxSize = maxSize;
    }

    public Buffer getHeader() {
        Buffer buffer = this._headers.poll();
        if (buffer == null) {
            buffer = this.newHeader();
        } else {
            this._size.decrementAndGet();
        }
        return buffer;
    }

    public Buffer getBuffer() {
        Buffer buffer = this._buffers.poll();
        if (buffer == null) {
            buffer = this.newBuffer();
        } else {
            this._size.decrementAndGet();
        }
        return buffer;
    }

    public Buffer getBuffer(int size) {
        if (this._otherHeaders && size == this.getHeaderSize()) {
            return this.getHeader();
        }
        if (this._otherBuffers && size == this.getBufferSize()) {
            return this.getBuffer();
        }
        Buffer buffer = this._others.poll();
        while (buffer != null && buffer.capacity() != size) {
            this._size.decrementAndGet();
            buffer = this._others.poll();
        }
        if (buffer == null) {
            buffer = this.newBuffer(size);
        } else {
            this._size.decrementAndGet();
        }
        return buffer;
    }

    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (buffer.isVolatile() || buffer.isImmutable()) {
            return;
        }
        if (this._size.incrementAndGet() > this._maxSize) {
            this._size.decrementAndGet();
        } else if (this.isHeader(buffer)) {
            this._headers.add(buffer);
        } else if (this.isBuffer(buffer)) {
            this._buffers.add(buffer);
        } else {
            this._others.add(buffer);
        }
    }

    public String toString() {
        return String.format("%s [%d/%d@%d,%d/%d@%d,%d/%d@-]", this.getClass().getSimpleName(), this._headers.size(), this._maxSize, this._headerSize, this._buffers.size(), this._maxSize, this._bufferSize, this._others.size(), this._maxSize);
    }
}

