/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.storm.shade.org.eclipse.jetty.io.AbstractBuffer;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.util.StringUtil;

public class ByteArrayBuffer
extends AbstractBuffer {
    static final int MAX_WRITE = Integer.getInteger("org.apache.storm.shade.org.eclipse.jetty.io.ByteArrayBuffer.MAX_WRITE", 131072);
    protected final byte[] _bytes;

    protected ByteArrayBuffer(int size, int access, boolean isVolatile) {
        this(new byte[size], 0, 0, access, isVolatile);
    }

    public ByteArrayBuffer(byte[] bytes) {
        this(bytes, 0, bytes.length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length) {
        this(bytes, index, length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access) {
        super(2, false);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access, boolean isVolatile) {
        super(2, isVolatile);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(int size) {
        this(new byte[size], 0, 0, 2);
        this.setPutIndex(0);
    }

    public ByteArrayBuffer(String value) {
        super(2, false);
        this._bytes = StringUtil.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = value;
    }

    public ByteArrayBuffer(String value, boolean immutable) {
        super(2, false);
        this._bytes = StringUtil.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        if (immutable) {
            this._access = 0;
            this._string = value;
        }
    }

    public ByteArrayBuffer(String value, String encoding) throws UnsupportedEncodingException {
        super(2, false);
        this._bytes = value.getBytes(encoding);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = value;
    }

    public byte[] array() {
        return this._bytes;
    }

    public int capacity() {
        return this._bytes.length;
    }

    public void compact() {
        int s;
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        int n = s = this.markIndex() >= 0 ? this.markIndex() : this.getIndex();
        if (s > 0) {
            int length = this.putIndex() - s;
            if (length > 0) {
                System.arraycopy(this._bytes, s, this._bytes, 0, length);
            }
            if (this.markIndex() > 0) {
                this.setMarkIndex(this.markIndex() - s);
            }
            this.setGetIndex(this.getIndex() - s);
            this.setPutIndex(this.putIndex() - s);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Buffer)) {
            return false;
        }
        if (obj instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase((Buffer)obj);
        }
        Buffer b = (Buffer)obj;
        if (b.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && obj instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)obj;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int get = this.getIndex();
        int bi = b.putIndex();
        int i = this.putIndex();
        while (i-- > get) {
            byte b2;
            byte b1 = this._bytes[i];
            if (b1 == (b2 = b.peek(--bi))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Buffer b) {
        if (b == this) {
            return true;
        }
        if (b == null || b.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && b instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)b;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int get = this.getIndex();
        int bi = b.putIndex();
        byte[] barray = b.array();
        if (barray == null) {
            int i = this.putIndex();
            while (i-- > get) {
                byte b2;
                byte b1 = this._bytes[i];
                if (b1 == (b2 = b.peek(--bi))) continue;
                if (97 <= b1 && b1 <= 122) {
                    b1 = (byte)(b1 - 97 + 65);
                }
                if (97 <= b2 && b2 <= 122) {
                    b2 = (byte)(b2 - 97 + 65);
                }
                if (b1 == b2) continue;
                return false;
            }
        } else {
            int i = this.putIndex();
            while (i-- > get) {
                byte b2;
                byte b1 = this._bytes[i];
                if (b1 == (b2 = barray[--bi])) continue;
                if (97 <= b1 && b1 <= 122) {
                    b1 = (byte)(b1 - 97 + 65);
                }
                if (97 <= b2 && b2 <= 122) {
                    b2 = (byte)(b2 - 97 + 65);
                }
                if (b1 == b2) continue;
                return false;
            }
        }
        return true;
    }

    public byte get() {
        return this._bytes[this._get++];
    }

    public int hashCode() {
        if (this._hash == 0 || this._hashGet != this._get || this._hashPut != this._put) {
            int get = this.getIndex();
            int i = this.putIndex();
            while (i-- > get) {
                byte b = this._bytes[i];
                if (97 <= b && b <= 122) {
                    b = (byte)(b - 97 + 65);
                }
                this._hash = 31 * this._hash + b;
            }
            if (this._hash == 0) {
                this._hash = -1;
            }
            this._hashGet = this._get;
            this._hashPut = this._put;
        }
        return this._hash;
    }

    public byte peek(int index) {
        return this._bytes[index];
    }

    public int peek(int index, byte[] b, int offset, int length) {
        int l = length;
        if (index + l > this.capacity() && (l = this.capacity() - index) == 0) {
            return -1;
        }
        if (l < 0) {
            return -1;
        }
        System.arraycopy(this._bytes, index, b, offset, l);
        return l;
    }

    public void poke(int index, byte b) {
        this._bytes[index] = b;
    }

    public int poke(int index, Buffer src) {
        byte[] src_array;
        this._hash = 0;
        int length = src.length();
        if (index + length > this.capacity()) {
            length = this.capacity() - index;
        }
        if ((src_array = src.array()) != null) {
            System.arraycopy(src_array, src.getIndex(), this._bytes, index, length);
        } else {
            int s = src.getIndex();
            for (int i = 0; i < length; ++i) {
                this._bytes[index++] = src.peek(s++);
            }
        }
        return length;
    }

    public int poke(int index, byte[] b, int offset, int length) {
        this._hash = 0;
        if (index + length > this.capacity()) {
            length = this.capacity() - index;
        }
        System.arraycopy(b, offset, this._bytes, index, length);
        return length;
    }

    public void writeTo(OutputStream out) throws IOException {
        int len;
        if (MAX_WRITE > 0 && len > MAX_WRITE) {
            int c;
            int off = this.getIndex();
            for (len = this.length(); len > 0; len -= c) {
                c = len > MAX_WRITE ? MAX_WRITE : len;
                out.write(this._bytes, off, c);
                off += c;
            }
        } else {
            out.write(this._bytes, this.getIndex(), len);
        }
        if (!this.isImmutable()) {
            this.clear();
        }
    }

    public int readFrom(InputStream in, int max) throws IOException {
        if (max < 0 || max > this.space()) {
            max = this.space();
        }
        int p = this.putIndex();
        int len = 0;
        int total = 0;
        int available = max;
        while (total < max && (len = in.read(this._bytes, p, available)) >= 0) {
            if (len > 0) {
                total += len;
                available -= len;
                this.setPutIndex(p += len);
            }
            if (in.available() > 0) continue;
        }
        if (len < 0 && total == 0) {
            return -1;
        }
        return total;
    }

    public int space() {
        return this._bytes.length - this._put;
    }

    public static class CaseInsensitive
    extends ByteArrayBuffer
    implements Buffer.CaseInsensitve {
        public CaseInsensitive(String s) {
            super(s);
        }

        public CaseInsensitive(byte[] b, int o, int l, int rw) {
            super(b, o, l, rw);
        }

        public boolean equals(Object obj) {
            return obj instanceof Buffer && this.equalsIgnoreCase((Buffer)obj);
        }
    }
}

