/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.client.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.storm.shade.org.eclipse.jetty.client.HttpDestination;
import org.apache.storm.shade.org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.apache.storm.shade.org.eclipse.jetty.client.HttpExchange;
import org.apache.storm.shade.org.eclipse.jetty.client.security.BasicAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.client.security.DigestAuthentication;
import org.apache.storm.shade.org.eclipse.jetty.client.security.Realm;
import org.apache.storm.shade.org.eclipse.jetty.client.security.RealmResolver;
import org.apache.storm.shade.org.eclipse.jetty.http.HttpHeaders;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.util.StringUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityListener
extends HttpEventListenerWrapper {
    private static final Logger LOG = Log.getLogger(SecurityListener.class);
    private HttpDestination _destination;
    private HttpExchange _exchange;
    private boolean _requestComplete;
    private boolean _responseComplete;
    private boolean _needIntercept;
    private int _attempts = 0;

    public SecurityListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
    }

    protected String scrapeAuthenticationType(String authString) {
        String authType;
        if (authString.indexOf(" ") == -1) {
            authType = authString.toString().trim();
        } else {
            String authResponse = authString.toString();
            authType = authResponse.substring(0, authResponse.indexOf(" ")).trim();
        }
        return authType;
    }

    protected Map<String, String> scrapeAuthenticationDetails(String authString) {
        HashMap<String, String> authenticationDetails = new HashMap<String, String>();
        authString = authString.substring(authString.indexOf(" ") + 1, authString.length());
        StringTokenizer strtok = new StringTokenizer(authString, ",");
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            String[] pair = token.split("=");
            if (pair.length == 2) {
                String itemName = pair[0].trim();
                String itemValue = pair[1].trim();
                itemValue = StringUtil.unquote(itemValue);
                authenticationDetails.put(itemName, itemValue);
                continue;
            }
            LOG.debug("SecurityListener: missed scraping authentication details - " + token, new Object[0]);
        }
        return authenticationDetails;
    }

    @Override
    public void onResponseStatus(Buffer version, int status2, Buffer reason) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SecurityListener:Response Status: " + status2, new Object[0]);
        }
        if (status2 == 401 && this._attempts < this._destination.getHttpClient().maxRetries()) {
            this.setDelegatingResponses(false);
            this._needIntercept = true;
        } else {
            this.setDelegatingResponses(true);
            this.setDelegatingRequests(true);
            this._needIntercept = false;
        }
        super.onResponseStatus(version, status2, reason);
    }

    @Override
    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SecurityListener:Header: " + name.toString() + " / " + value.toString(), new Object[0]);
        }
        if (!this.isDelegatingResponses()) {
            int header2 = HttpHeaders.CACHE.getOrdinal(name);
            switch (header2) {
                case 51: {
                    String authString = value.toString();
                    String type = this.scrapeAuthenticationType(authString);
                    Map<String, String> details = this.scrapeAuthenticationDetails(authString);
                    String pathSpec = "/";
                    RealmResolver realmResolver = this._destination.getHttpClient().getRealmResolver();
                    if (realmResolver == null) break;
                    Realm realm = realmResolver.getRealm(details.get("realm"), this._destination, pathSpec);
                    if (realm == null) {
                        LOG.warn("Unknown Security Realm: " + details.get("realm"), new Object[0]);
                        break;
                    }
                    if ("digest".equalsIgnoreCase(type)) {
                        this._destination.addAuthorization("/", new DigestAuthentication(realm, details));
                        break;
                    }
                    if (!"basic".equalsIgnoreCase(type)) break;
                    this._destination.addAuthorization(pathSpec, new BasicAuthentication(realm));
                }
            }
        }
        super.onResponseHeader(name, value);
    }

    @Override
    public void onRequestComplete() throws IOException {
        this._requestComplete = true;
        if (this._needIntercept) {
            if (this._requestComplete && this._responseComplete) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onRequestComplete, Both complete: Resending from onResponseComplete " + this._exchange, new Object[0]);
                }
                this._responseComplete = false;
                this._requestComplete = false;
                this.setDelegatingRequests(true);
                this.setDelegatingResponses(true);
                this._destination.resend(this._exchange);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onRequestComplete, Response not yet complete onRequestComplete, calling super for " + this._exchange, new Object[0]);
                }
                super.onRequestComplete();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequestComplete, delegating to super with Request complete=" + this._requestComplete + ", response complete=" + this._responseComplete + " " + this._exchange, new Object[0]);
            }
            super.onRequestComplete();
        }
    }

    @Override
    public void onResponseComplete() throws IOException {
        this._responseComplete = true;
        if (this._needIntercept) {
            if (this._requestComplete && this._responseComplete) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onResponseComplete, Both complete: Resending from onResponseComplete" + this._exchange, new Object[0]);
                }
                this._responseComplete = false;
                this._requestComplete = false;
                this.setDelegatingResponses(true);
                this.setDelegatingRequests(true);
                this._destination.resend(this._exchange);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onResponseComplete, Request not yet complete from onResponseComplete,  calling super " + this._exchange, new Object[0]);
                }
                super.onResponseComplete();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OnResponseComplete, delegating to super with Request complete=" + this._requestComplete + ", response complete=" + this._responseComplete + " " + this._exchange, new Object[0]);
            }
            super.onResponseComplete();
        }
    }

    @Override
    public void onRetry() {
        ++this._attempts;
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        this._requestComplete = false;
        this._responseComplete = false;
        this._needIntercept = false;
        super.onRetry();
    }
}

