/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.client;

import java.io.IOException;
import org.apache.storm.shade.org.eclipse.jetty.client.HttpExchange;
import org.apache.storm.shade.org.eclipse.jetty.http.HttpFields;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;

public class CachedExchange
extends HttpExchange {
    private final HttpFields _responseFields;
    private volatile int _responseStatus;

    public CachedExchange(boolean cacheHeaders) {
        this._responseFields = cacheHeaders ? new HttpFields() : null;
    }

    public synchronized int getResponseStatus() {
        if (this.getStatus() < 5) {
            throw new IllegalStateException("Response not received yet");
        }
        return this._responseStatus;
    }

    public synchronized HttpFields getResponseFields() {
        if (this.getStatus() < 6) {
            throw new IllegalStateException("Headers not completely received yet");
        }
        return this._responseFields;
    }

    protected synchronized void onResponseStatus(Buffer version, int status2, Buffer reason) throws IOException {
        this._responseStatus = status2;
        super.onResponseStatus(version, status2, reason);
    }

    protected synchronized void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._responseFields != null) {
            this._responseFields.add(name, value.asImmutableBuffer());
        }
        super.onResponseHeader(name, value);
    }
}

