/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import org.apache.storm.shade.org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.storm.shade.org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.storm.shade.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.storm.shade.org.apache.zookeeper.server.ZKDatabase;
import org.apache.storm.shade.org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.storm.shade.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeerMain {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerMain.class);
    private static final String USAGE = "Usage: QuorumPeerMain configfile";
    protected QuorumPeer quorumPeer;

    public static void main(String[] args) {
        QuorumPeerMain main = new QuorumPeerMain();
        try {
            main.initializeAndRun(args);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
            LOG.info(USAGE);
            System.err.println(USAGE);
            System.exit(2);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            LOG.error("Invalid config, exiting abnormally", (Throwable)e);
            System.err.println("Invalid config, exiting abnormally");
            System.exit(2);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Exiting normally");
        System.exit(0);
    }

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
        QuorumPeerConfig config2 = new QuorumPeerConfig();
        if (args.length == 1) {
            config2.parse(args[0]);
        }
        DatadirCleanupManager purgeMgr = new DatadirCleanupManager(config2.getDataDir(), config2.getDataLogDir(), config2.getSnapRetainCount(), config2.getPurgeInterval());
        purgeMgr.start();
        if (args.length == 1 && config2.servers.size() > 0) {
            this.runFromConfig(config2);
        } else {
            LOG.warn("Either no config or no quorum defined in config, running  in standalone mode");
            ZooKeeperServerMain.main(args);
        }
    }

    public void runFromConfig(QuorumPeerConfig config2) throws IOException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException e) {
            LOG.warn("Unable to register log4j JMX control", (Throwable)e);
        }
        LOG.info("Starting quorum peer");
        try {
            ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
            cnxnFactory.configure(config2.getClientPortAddress(), config2.getMaxClientCnxns());
            this.quorumPeer = new QuorumPeer();
            this.quorumPeer.setClientPortAddress(config2.getClientPortAddress());
            this.quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(config2.getDataLogDir()), new File(config2.getDataDir())));
            this.quorumPeer.setQuorumPeers(config2.getServers());
            this.quorumPeer.setElectionType(config2.getElectionAlg());
            this.quorumPeer.setMyid(config2.getServerId());
            this.quorumPeer.setTickTime(config2.getTickTime());
            this.quorumPeer.setMinSessionTimeout(config2.getMinSessionTimeout());
            this.quorumPeer.setMaxSessionTimeout(config2.getMaxSessionTimeout());
            this.quorumPeer.setInitLimit(config2.getInitLimit());
            this.quorumPeer.setSyncLimit(config2.getSyncLimit());
            this.quorumPeer.setQuorumVerifier(config2.getQuorumVerifier());
            this.quorumPeer.setCnxnFactory(cnxnFactory);
            this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
            this.quorumPeer.setLearnerType(config2.getPeerType());
            this.quorumPeer.setSyncEnabled(config2.getSyncEnabled());
            this.quorumPeer.setQuorumListenOnAllIPs(config2.getQuorumListenOnAllIPs());
            this.quorumPeer.start();
            this.quorumPeer.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Quorum Peer interrupted", (Throwable)e);
        }
    }
}

