/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ServerConfig {
    protected InetSocketAddress clientPortAddress;
    protected String dataDir;
    protected String dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;

    public void parse(String[] args) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Invalid args:" + Arrays.toString(args));
        }
        this.clientPortAddress = new InetSocketAddress(Integer.parseInt(args[0]));
        this.dataLogDir = this.dataDir = args[1];
        if (args.length == 3) {
            this.tickTime = Integer.parseInt(args[2]);
        }
        if (args.length == 4) {
            this.maxClientCnxns = Integer.parseInt(args[3]);
        }
    }

    public void parse(String path) throws QuorumPeerConfig.ConfigException {
        QuorumPeerConfig config2 = new QuorumPeerConfig();
        config2.parse(path);
        this.readFrom(config2);
    }

    public void readFrom(QuorumPeerConfig config2) {
        this.clientPortAddress = config2.getClientPortAddress();
        this.dataDir = config2.getDataDir();
        this.dataLogDir = config2.getDataLogDir();
        this.tickTime = config2.getTickTime();
        this.maxClientCnxns = config2.getMaxClientCnxns();
        this.minSessionTimeout = config2.getMinSessionTimeout();
        this.maxSessionTimeout = config2.getMaxSessionTimeout();
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }
}

