/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.OutputArchive;
import org.apache.storm.shade.org.apache.jute.Record;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.apache.storm.shade.org.apache.zookeeper.data.StatPersisted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode
implements Record {
    DataNode parent;
    byte[] data;
    Long acl;
    public StatPersisted stat;
    private Set<String> children = null;

    DataNode() {
    }

    public DataNode(DataNode parent, byte[] data2, Long acl, StatPersisted stat) {
        this.parent = parent;
        this.data = data2;
        this.acl = acl;
        this.stat = stat;
    }

    public synchronized boolean addChild(String child) {
        if (this.children == null) {
            this.children = new HashSet<String>(8);
        }
        return this.children.add(child);
    }

    public synchronized boolean removeChild(String child) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(child);
    }

    public synchronized void setChildren(HashSet<String> children) {
        this.children = children;
    }

    public synchronized Set<String> getChildren() {
        return this.children;
    }

    public synchronized void copyStat(Stat to) {
        to.setAversion(this.stat.getAversion());
        to.setCtime(this.stat.getCtime());
        to.setCzxid(this.stat.getCzxid());
        to.setMtime(this.stat.getMtime());
        to.setMzxid(this.stat.getMzxid());
        to.setPzxid(this.stat.getPzxid());
        to.setVersion(this.stat.getVersion());
        to.setEphemeralOwner(this.stat.getEphemeralOwner());
        to.setDataLength(this.data == null ? 0 : this.data.length);
        int numChildren = 0;
        if (this.children != null) {
            numChildren = this.children.size();
        }
        to.setCversion(this.stat.getCversion() * 2 - numChildren);
        to.setNumChildren(numChildren);
    }

    @Override
    public synchronized void deserialize(InputArchive archive, String tag2) throws IOException {
        archive.startRecord("node");
        this.data = archive.readBuffer("data");
        this.acl = archive.readLong("acl");
        this.stat = new StatPersisted();
        this.stat.deserialize(archive, "statpersisted");
        archive.endRecord("node");
    }

    @Override
    public synchronized void serialize(OutputArchive archive, String tag2) throws IOException {
        archive.startRecord(this, "node");
        archive.writeBuffer(this.data, "data");
        archive.writeLong(this.acl, "acl");
        this.stat.serialize(archive, "statpersisted");
        archive.endRecord(this, "node");
    }
}

