/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.proto;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.storm.shade.org.apache.jute.BinaryInputArchive;
import org.apache.storm.shade.org.apache.jute.BinaryOutputArchive;
import org.apache.storm.shade.org.apache.jute.CsvOutputArchive;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.OutputArchive;
import org.apache.storm.shade.org.apache.jute.Record;
import org.apache.storm.shade.org.apache.jute.Utils;

public class AuthPacket
implements Record {
    private int type;
    private String scheme;
    private byte[] auth;

    public AuthPacket() {
    }

    public AuthPacket(int type, String scheme, byte[] auth) {
        this.type = type;
        this.scheme = scheme;
        this.auth = auth;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int m_) {
        this.type = m_;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String m_) {
        this.scheme = m_;
    }

    public byte[] getAuth() {
        return this.auth;
    }

    public void setAuth(byte[] m_) {
        this.auth = m_;
    }

    public void serialize(OutputArchive a_, String tag2) throws IOException {
        a_.startRecord(this, tag2);
        a_.writeInt(this.type, "type");
        a_.writeString(this.scheme, "scheme");
        a_.writeBuffer(this.auth, "auth");
        a_.endRecord(this, tag2);
    }

    public void deserialize(InputArchive a_, String tag2) throws IOException {
        a_.startRecord(tag2);
        this.type = a_.readInt("type");
        this.scheme = a_.readString("scheme");
        this.auth = a_.readBuffer("auth");
        a_.endRecord(tag2);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeInt(this.type, "type");
            a_.writeString(this.scheme, "scheme");
            a_.writeBuffer(this.auth, "auth");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public void write(DataOutput out) throws IOException {
        BinaryOutputArchive archive = new BinaryOutputArchive(out);
        this.serialize(archive, "");
    }

    public void readFields(DataInput in) throws IOException {
        BinaryInputArchive archive = new BinaryInputArchive(in);
        this.deserialize(archive, "");
    }

    public int compareTo(Object peer_) throws ClassCastException {
        if (!(peer_ instanceof AuthPacket)) {
            throw new ClassCastException("Comparing different types of records.");
        }
        AuthPacket peer = (AuthPacket)peer_;
        int ret = 0;
        int n = this.type == peer.type ? 0 : (ret = this.type < peer.type ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        ret = this.scheme.compareTo(peer.scheme);
        if (ret != 0) {
            return ret;
        }
        byte[] my = this.auth;
        byte[] ur = peer.auth;
        ret = Utils.compareBytes(my, 0, my.length, ur, 0, ur.length);
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof AuthPacket)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        AuthPacket peer = (AuthPacket)peer_;
        boolean ret = false;
        boolean bl = ret = this.type == peer.type;
        if (!ret) {
            return ret;
        }
        ret = this.scheme.equals(peer.scheme);
        if (!ret) {
            return ret;
        }
        ret = Utils.bufEquals(this.auth, peer.auth);
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result2 = 17;
        int ret = this.type;
        result2 = 37 * result2 + ret;
        ret = this.scheme.hashCode();
        result2 = 37 * result2 + ret;
        ret = Arrays.toString(this.auth).hashCode();
        result2 = 37 * result2 + ret;
        return result2;
    }

    public static String signature() {
        return "LAuthPacket(isB)";
    }
}

