/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.jute;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.storm.shade.org.apache.jute.Index;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.Record;
import org.apache.storm.shade.org.apache.jute.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlInputArchive
implements InputArchive {
    private ArrayList<Value> valList = new ArrayList();
    private int vLen;
    private int vIdx;

    private Value next() throws IOException {
        if (this.vIdx < this.vLen) {
            Value v = this.valList.get(this.vIdx);
            this.valList.set(this.vIdx, null);
            ++this.vIdx;
            return v;
        }
        throw new IOException("Error in deserialization.");
    }

    static XmlInputArchive getArchive(InputStream strm) throws ParserConfigurationException, SAXException, IOException {
        return new XmlInputArchive(strm);
    }

    public XmlInputArchive(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        XMLParser handler2 = new XMLParser(this.valList);
        SAXParserFactory factory2 = SAXParserFactory.newInstance();
        SAXParser parser = factory2.newSAXParser();
        parser.parse(in, (DefaultHandler)handler2);
        this.vLen = this.valList.size();
        this.vIdx = 0;
    }

    public byte readByte(String tag2) throws IOException {
        Value v = this.next();
        if (!"ex:i1".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Byte.parseByte(v.getValue());
    }

    public boolean readBool(String tag2) throws IOException {
        Value v = this.next();
        if (!"boolean".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return "1".equals(v.getValue());
    }

    public int readInt(String tag2) throws IOException {
        Value v = this.next();
        if (!"i4".equals(v.getType()) && !"int".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Integer.parseInt(v.getValue());
    }

    public long readLong(String tag2) throws IOException {
        Value v = this.next();
        if (!"ex:i8".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Long.parseLong(v.getValue());
    }

    public float readFloat(String tag2) throws IOException {
        Value v = this.next();
        if (!"ex:float".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Float.parseFloat(v.getValue());
    }

    public double readDouble(String tag2) throws IOException {
        Value v = this.next();
        if (!"double".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Double.parseDouble(v.getValue());
    }

    public String readString(String tag2) throws IOException {
        Value v = this.next();
        if (!"string".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Utils.fromXMLString(v.getValue());
    }

    public byte[] readBuffer(String tag2) throws IOException {
        Value v = this.next();
        if (!"string".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return Utils.fromXMLBuffer(v.getValue());
    }

    public void readRecord(Record r, String tag2) throws IOException {
        r.deserialize(this, tag2);
    }

    public void startRecord(String tag2) throws IOException {
        Value v = this.next();
        if (!"struct".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
    }

    public void endRecord(String tag2) throws IOException {
        Value v = this.next();
        if (!"/struct".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
    }

    public Index startVector(String tag2) throws IOException {
        Value v = this.next();
        if (!"array".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag2 + ".");
        }
        return new XmlIndex();
    }

    public void endVector(String tag2) throws IOException {
    }

    public Index startMap(String tag2) throws IOException {
        return this.startVector(tag2);
    }

    public void endMap(String tag2) throws IOException {
        this.endVector(tag2);
    }

    private class XmlIndex
    implements Index {
        private XmlIndex() {
        }

        public boolean done() {
            Value v = (Value)XmlInputArchive.this.valList.get(XmlInputArchive.this.vIdx);
            if ("/array".equals(v.getType())) {
                XmlInputArchive.this.valList.set(XmlInputArchive.this.vIdx, null);
                XmlInputArchive.this.vIdx++;
                return true;
            }
            return false;
        }

        public void incr() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XMLParser
    extends DefaultHandler {
        private boolean charsValid = false;
        private ArrayList<Value> valList;

        private XMLParser(ArrayList<Value> vlist) {
            this.valList = vlist;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String ns, String sname, String qname, Attributes attrs) throws SAXException {
            this.charsValid = false;
            if ("boolean".equals(qname) || "i4".equals(qname) || "int".equals(qname) || "string".equals(qname) || "double".equals(qname) || "ex:i1".equals(qname) || "ex:i8".equals(qname) || "ex:float".equals(qname)) {
                this.charsValid = true;
                this.valList.add(new Value(qname));
            } else if ("struct".equals(qname) || "array".equals(qname)) {
                this.valList.add(new Value(qname));
            }
        }

        @Override
        public void endElement(String ns, String sname, String qname) throws SAXException {
            this.charsValid = false;
            if ("struct".equals(qname) || "array".equals(qname)) {
                this.valList.add(new Value("/" + qname));
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (this.charsValid) {
                Value v = this.valList.get(this.valList.size() - 1);
                v.addChars(buf, offset, len);
            }
        }
    }

    private static class Value {
        private String type;
        private StringBuffer sb;

        public Value(String t) {
            this.type = t;
            this.sb = new StringBuffer();
        }

        public void addChars(char[] buf, int offset, int len) {
            this.sb.append(buf, offset, len);
        }

        public String getValue() {
            return this.sb.toString();
        }

        public String getType() {
            return this.type;
        }
    }
}

