/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.jute;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.storm.shade.org.apache.jute.Index;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.Record;

public class BinaryInputArchive
implements InputArchive {
    private DataInput in;
    public static final int maxBuffer = Integer.getInteger("jute.maxbuffer", 1048575);

    public static BinaryInputArchive getArchive(InputStream strm) {
        return new BinaryInputArchive(new DataInputStream(strm));
    }

    public BinaryInputArchive(DataInput in) {
        this.in = in;
    }

    public byte readByte(String tag2) throws IOException {
        return this.in.readByte();
    }

    public boolean readBool(String tag2) throws IOException {
        return this.in.readBoolean();
    }

    public int readInt(String tag2) throws IOException {
        return this.in.readInt();
    }

    public long readLong(String tag2) throws IOException {
        return this.in.readLong();
    }

    public float readFloat(String tag2) throws IOException {
        return this.in.readFloat();
    }

    public double readDouble(String tag2) throws IOException {
        return this.in.readDouble();
    }

    public String readString(String tag2) throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        this.in.readFully(b);
        return new String(b, "UTF8");
    }

    public byte[] readBuffer(String tag2) throws IOException {
        int len = this.readInt(tag2);
        if (len == -1) {
            return null;
        }
        if (len < 0 || len > maxBuffer + 1024) {
            throw new IOException("Unreasonable length = " + len);
        }
        byte[] arr = new byte[len];
        this.in.readFully(arr);
        return arr;
    }

    public void readRecord(Record r, String tag2) throws IOException {
        r.deserialize(this, tag2);
    }

    public void startRecord(String tag2) throws IOException {
    }

    public void endRecord(String tag2) throws IOException {
    }

    public Index startVector(String tag2) throws IOException {
        int len = this.readInt(tag2);
        if (len == -1) {
            return null;
        }
        return new BinaryIndex(len);
    }

    public void endVector(String tag2) throws IOException {
    }

    public Index startMap(String tag2) throws IOException {
        return new BinaryIndex(this.readInt(tag2));
    }

    public void endMap(String tag2) throws IOException {
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        public boolean done() {
            return this.nelems <= 0;
        }

        public void incr() {
            --this.nelems;
        }
    }
}

