/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.protocol;

import java.io.IOException;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpEntity;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpResponseInterceptor;
import org.apache.storm.shade.org.apache.http.HttpVersion;
import org.apache.storm.shade.org.apache.http.ProtocolVersion;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseConnControl
implements HttpResponseInterceptor {
    public void process(HttpResponse response2, HttpContext context2) throws HttpException, IOException {
        HttpRequest request;
        if (response2 == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        int status2 = response2.getStatusLine().getStatusCode();
        if (status2 == 400 || status2 == 408 || status2 == 411 || status2 == 413 || status2 == 414 || status2 == 503 || status2 == 501) {
            response2.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response2.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response2.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response2.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response2.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = (HttpRequest)context2.getAttribute("http.request")) != null) {
            Header header2 = request.getFirstHeader("Connection");
            if (header2 != null) {
                response2.setHeader("Connection", header2.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response2.setHeader("Connection", "Close");
            }
        }
    }
}

