/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.protocol;

import java.io.IOException;
import org.apache.storm.shade.org.apache.http.ConnectionReuseStrategy;
import org.apache.storm.shade.org.apache.http.HttpEntity;
import org.apache.storm.shade.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpResponseFactory;
import org.apache.storm.shade.org.apache.http.HttpServerConnection;
import org.apache.storm.shade.org.apache.http.HttpVersion;
import org.apache.storm.shade.org.apache.http.MethodNotSupportedException;
import org.apache.storm.shade.org.apache.http.ProtocolException;
import org.apache.storm.shade.org.apache.http.UnsupportedHttpVersionException;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.entity.ByteArrayEntity;
import org.apache.storm.shade.org.apache.http.params.DefaultedHttpParams;
import org.apache.storm.shade.org.apache.http.params.HttpParams;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.storm.shade.org.apache.http.protocol.HttpProcessor;
import org.apache.storm.shade.org.apache.http.protocol.HttpRequestHandler;
import org.apache.storm.shade.org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.storm.shade.org.apache.http.util.EncodingUtils;
import org.apache.storm.shade.org.apache.http.util.EntityUtils;

@Immutable
public class HttpService {
    private volatile HttpParams params = null;
    private volatile HttpProcessor processor = null;
    private volatile HttpRequestHandlerResolver handlerResolver = null;
    private volatile ConnectionReuseStrategy connStrategy = null;
    private volatile HttpResponseFactory responseFactory = null;
    private volatile HttpExpectationVerifier expectationVerifier = null;

    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerResolver handlerResolver, HttpExpectationVerifier expectationVerifier, HttpParams params2) {
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.processor = processor;
        this.connStrategy = connStrategy;
        this.responseFactory = responseFactory;
        this.handlerResolver = handlerResolver;
        this.expectationVerifier = expectationVerifier;
        this.params = params2;
    }

    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerResolver handlerResolver, HttpParams params2) {
        this(processor, connStrategy, responseFactory, handlerResolver, null, params2);
    }

    @Deprecated
    public HttpService(HttpProcessor proc, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory) {
        this.setHttpProcessor(proc);
        this.setConnReuseStrategy(connStrategy);
        this.setResponseFactory(responseFactory);
    }

    @Deprecated
    public void setHttpProcessor(HttpProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        this.processor = processor;
    }

    @Deprecated
    public void setConnReuseStrategy(ConnectionReuseStrategy connStrategy) {
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        this.connStrategy = connStrategy;
    }

    @Deprecated
    public void setResponseFactory(HttpResponseFactory responseFactory) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
    }

    @Deprecated
    public void setParams(HttpParams params2) {
        this.params = params2;
    }

    @Deprecated
    public void setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    @Deprecated
    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void handleRequest(HttpServerConnection conn, HttpContext context2) throws IOException, HttpException {
        context2.setAttribute("http.connection", conn);
        HttpResponse response2 = null;
        try {
            HttpRequest request = conn.receiveRequestHeader();
            request.setParams(new DefaultedHttpParams(request.getParams(), this.params));
            if (request instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                    response2 = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 100, context2);
                    response2.setParams(new DefaultedHttpParams(response2.getParams(), this.params));
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(request, response2, context2);
                        }
                        catch (HttpException ex) {
                            response2 = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context2);
                            response2.setParams(new DefaultedHttpParams(response2.getParams(), this.params));
                            this.handleException(ex, response2);
                        }
                    }
                    if (response2.getStatusLine().getStatusCode() < 200) {
                        conn.sendResponseHeader(response2);
                        conn.flush();
                        response2 = null;
                        conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
                    }
                } else {
                    conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
                }
            }
            context2.setAttribute("http.request", request);
            if (response2 == null) {
                response2 = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 200, context2);
                response2.setParams(new DefaultedHttpParams(response2.getParams(), this.params));
                this.processor.process(request, context2);
                this.doService(request, response2, context2);
            }
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                EntityUtils.consume(entity);
            }
        }
        catch (HttpException ex) {
            response2 = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context2);
            response2.setParams(new DefaultedHttpParams(response2.getParams(), this.params));
            this.handleException(ex, response2);
        }
        context2.setAttribute("http.response", response2);
        this.processor.process(response2, context2);
        conn.sendResponseHeader(response2);
        conn.sendResponseEntity(response2);
        conn.flush();
        if (!this.connStrategy.keepAlive(response2, context2)) {
            conn.close();
        }
    }

    protected void handleException(HttpException ex, HttpResponse response2) {
        if (ex instanceof MethodNotSupportedException) {
            response2.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response2.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response2.setStatusCode(400);
        } else {
            response2.setStatusCode(500);
        }
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        byte[] msg = EncodingUtils.getAsciiBytes(message);
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response2.setEntity(entity);
    }

    protected void doService(HttpRequest request, HttpResponse response2, HttpContext context2) throws HttpException, IOException {
        HttpRequestHandler handler2 = null;
        if (this.handlerResolver != null) {
            String requestURI = request.getRequestLine().getUri();
            handler2 = this.handlerResolver.lookup(requestURI);
        }
        if (handler2 != null) {
            handler2.handle(request, response2, context2);
        } else {
            response2.setStatusCode(501);
        }
    }
}

