/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.protocol;

import java.io.IOException;
import org.apache.storm.shade.org.apache.http.HttpClientConnection;
import org.apache.storm.shade.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpVersion;
import org.apache.storm.shade.org.apache.http.ProtocolException;
import org.apache.storm.shade.org.apache.http.ProtocolVersion;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpProcessor;

@Immutable
public class HttpRequestExecutor {
    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response2) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status2 = response2.getStatusLine().getStatusCode();
        return status2 >= 200 && status2 != 204 && status2 != 304 && status2 != 205;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Client connection may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        try {
            HttpResponse response2 = this.doSendRequest(request, conn, context2);
            if (response2 == null) {
                response2 = this.doReceiveResponse(request, conn, context2);
            }
            return response2;
        }
        catch (IOException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (RuntimeException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
    }

    private static final void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext context2) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        context2.setAttribute("http.request", request);
        processor.process(request, context2);
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response2 = null;
        context2.setAttribute("http.connection", conn);
        context2.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            boolean sendentity = true;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)request).expectContinue() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                conn.flush();
                int tms = request.getParams().getIntParameter("http.protocol.wait-for-continue", 2000);
                if (conn.isResponseAvailable(tms)) {
                    int status2;
                    response2 = conn.receiveResponseHeader();
                    if (this.canResponseHaveBody(request, response2)) {
                        conn.receiveResponseEntity(response2);
                    }
                    if ((status2 = response2.getStatusLine().getStatusCode()) < 200) {
                        if (status2 != 100) {
                            throw new ProtocolException("Unexpected response: " + response2.getStatusLine());
                        }
                        response2 = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                conn.sendRequestEntity((HttpEntityEnclosingRequest)request);
            }
        }
        conn.flush();
        context2.setAttribute("http.request_sent", Boolean.TRUE);
        return response2;
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response2 = null;
        int statuscode = 0;
        while (response2 == null || statuscode < 200) {
            response2 = conn.receiveResponseHeader();
            if (this.canResponseHaveBody(request, response2)) {
                conn.receiveResponseEntity(response2);
            }
            statuscode = response2.getStatusLine().getStatusCode();
        }
        return response2;
    }

    public void postProcess(HttpResponse response2, HttpProcessor processor, HttpContext context2) throws HttpException, IOException {
        if (response2 == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context2 == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        context2.setAttribute("http.response", response2);
        processor.process(response2, context2);
    }
}

