/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.params;

import org.apache.storm.shade.org.apache.http.params.CoreConnectionPNames;
import org.apache.storm.shade.org.apache.http.params.HttpParams;

public final class HttpConnectionParams
implements CoreConnectionPNames {
    private HttpConnectionParams() {
    }

    public static int getSoTimeout(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getIntParameter("http.socket.timeout", 0);
    }

    public static void setSoTimeout(HttpParams params2, int timeout) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setIntParameter("http.socket.timeout", timeout);
    }

    public static boolean getSoReuseaddr(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getBooleanParameter("http.socket.reuseaddr", false);
    }

    public static void setSoReuseaddr(HttpParams params2, boolean reuseaddr) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setBooleanParameter("http.socket.reuseaddr", reuseaddr);
    }

    public static boolean getTcpNoDelay(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getBooleanParameter("http.tcp.nodelay", true);
    }

    public static void setTcpNoDelay(HttpParams params2, boolean value) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setBooleanParameter("http.tcp.nodelay", value);
    }

    public static int getSocketBufferSize(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getIntParameter("http.socket.buffer-size", -1);
    }

    public static void setSocketBufferSize(HttpParams params2, int size) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setIntParameter("http.socket.buffer-size", size);
    }

    public static int getLinger(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getIntParameter("http.socket.linger", -1);
    }

    public static void setLinger(HttpParams params2, int value) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setIntParameter("http.socket.linger", value);
    }

    public static int getConnectionTimeout(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getIntParameter("http.connection.timeout", 0);
    }

    public static void setConnectionTimeout(HttpParams params2, int timeout) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setIntParameter("http.connection.timeout", timeout);
    }

    public static boolean isStaleCheckingEnabled(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getBooleanParameter("http.connection.stalecheck", true);
    }

    public static void setStaleCheckingEnabled(HttpParams params2, boolean value) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setBooleanParameter("http.connection.stalecheck", value);
    }

    public static boolean getSoKeepalive(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getBooleanParameter("http.socket.keepalive", false);
    }

    public static void setSoKeepalive(HttpParams params2, boolean enableKeepalive) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setBooleanParameter("http.socket.keepalive", enableKeepalive);
    }
}

