/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.message;

import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HeaderIterator;
import org.apache.storm.shade.org.apache.http.HttpMessage;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.message.BasicHeader;
import org.apache.storm.shade.org.apache.http.message.HeaderGroup;
import org.apache.storm.shade.org.apache.http.params.BasicHttpParams;
import org.apache.storm.shade.org.apache.http.params.HttpParams;

@NotThreadSafe
public abstract class AbstractHttpMessage
implements HttpMessage {
    protected HeaderGroup headergroup = new HeaderGroup();
    protected HttpParams params;

    protected AbstractHttpMessage(HttpParams params2) {
        this.params = params2;
    }

    protected AbstractHttpMessage() {
        this(null);
    }

    public boolean containsHeader(String name) {
        return this.headergroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headergroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.headergroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.headergroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    public void addHeader(Header header2) {
        this.headergroup.addHeader(header2);
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.addHeader(new BasicHeader(name, value));
    }

    public void setHeader(Header header2) {
        this.headergroup.updateHeader(header2);
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.updateHeader(new BasicHeader(name, value));
    }

    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    public void removeHeader(Header header2) {
        this.headergroup.removeHeader(header2);
    }

    public void removeHeaders(String name) {
        if (name == null) {
            return;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header2 = i.nextHeader();
            if (!name.equalsIgnoreCase(header2.getName())) continue;
            i.remove();
        }
    }

    public HeaderIterator headerIterator() {
        return this.headergroup.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headergroup.iterator(name);
    }

    public HttpParams getParams() {
        if (this.params == null) {
            this.params = new BasicHttpParams();
        }
        return this.params;
    }

    public void setParams(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params2;
    }
}

