/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.impl.execchain.ClientExecChain;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull((Object)requestExecutor, (String)"HTTP request executor");
        Args.notNull((Object)retryStrategy, (String)"Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response2 = this.requestExecutor.execute(route2, request, context2, execAware);
            try {
                if (this.retryStrategy.retryRequest(response2, c, (HttpContext)((Object)context2))) {
                    response2.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace((Object)("Wait for " + nextInterval));
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response2;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response2.close();
                throw ex;
            }
            ++c;
        }
    }
}

