/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.execchain;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.NoHttpResponseException;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.client.HttpRequestRetryHandler;
import org.apache.storm.shade.org.apache.http.client.NonRepeatableRequestException;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.impl.execchain.ClientExecChain;
import org.apache.storm.shade.org.apache.http.impl.execchain.Proxies;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;

@Immutable
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull((Object)requestExecutor, (String)"HTTP request executor");
        Args.notNull((Object)retryHandler, (String)"HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull((Object)route2, (String)"HTTP route");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)((Object)context2), (String)"HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route2, request, context2, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    this.log.debug((Object)"Request has been aborted");
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, (HttpContext)((Object)context2))) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request to " + route2 + ": " + ex.getMessage()));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    if (!Proxies.isRepeatable(request)) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", ex);
                    }
                    request.setHeaders(origheaders);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Retrying request to " + route2));
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route2.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                ++execCount;
                continue;
            }
            break;
        }
    }
}

