/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.execchain;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.ProtocolException;
import org.apache.storm.shade.org.apache.http.annotation.ThreadSafe;
import org.apache.storm.shade.org.apache.http.auth.AuthScheme;
import org.apache.storm.shade.org.apache.http.auth.AuthState;
import org.apache.storm.shade.org.apache.http.client.RedirectException;
import org.apache.storm.shade.org.apache.http.client.RedirectStrategy;
import org.apache.storm.shade.org.apache.http.client.config.RequestConfig;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.methods.HttpUriRequest;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.client.utils.URIUtils;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.storm.shade.org.apache.http.impl.execchain.ClientExecChain;
import org.apache.storm.shade.org.apache.http.impl.execchain.Proxies;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.apache.storm.shade.org.apache.http.util.EntityUtils;

@ThreadSafe
public class RedirectExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(ClientExecChain requestExecutor, HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull((Object)requestExecutor, (String)"HTTP client request executor");
        Args.notNull((Object)routePlanner, (String)"HTTP route planner");
        Args.notNull((Object)redirectStrategy, (String)"HTTP redirect strategy");
        this.requestExecutor = requestExecutor;
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        RequestConfig config2;
        Args.notNull((Object)route2, (String)"HTTP route");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)((Object)context2), (String)"HTTP context");
        List<URI> redirectLocations = context2.getRedirectLocations();
        if (redirectLocations != null) {
            redirectLocations.clear();
        }
        int maxRedirects = (config2 = context2.getRequestConfig()).getMaxRedirects() > 0 ? config2.getMaxRedirects() : 50;
        HttpRoute currentRoute = route2;
        HttpRequestWrapper currentRequest = request;
        int redirectCount = 0;
        while (true) {
            CloseableHttpResponse response2 = this.requestExecutor.execute(currentRoute, currentRequest, context2, execAware);
            try {
                URI uri;
                HttpHost newTarget;
                if (!config2.isRedirectsEnabled()) return response2;
                if (!this.redirectStrategy.isRedirected(currentRequest, response2, (HttpContext)((Object)context2))) return response2;
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                HttpUriRequest redirect2 = this.redirectStrategy.getRedirect(currentRequest, response2, (HttpContext)((Object)context2));
                if (!redirect2.headerIterator().hasNext()) {
                    HttpRequest original = request.getOriginal();
                    redirect2.setHeaders(original.getAllHeaders());
                }
                if ((currentRequest = HttpRequestWrapper.wrap(redirect2)) instanceof HttpEntityEnclosingRequest) {
                    Proxies.enhanceEntity((HttpEntityEnclosingRequest)((Object)currentRequest));
                }
                if ((newTarget = URIUtils.extractHost(uri = currentRequest.getURI())) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + uri);
                }
                if (!currentRoute.getTargetHost().equals(newTarget)) {
                    AuthScheme authScheme;
                    AuthState proxyAuthState;
                    AuthState targetAuthState = context2.getTargetAuthState();
                    if (targetAuthState != null) {
                        this.log.debug((Object)"Resetting target auth state");
                        targetAuthState.reset();
                    }
                    if ((proxyAuthState = context2.getProxyAuthState()) != null && (authScheme = proxyAuthState.getAuthScheme()) != null && authScheme.isConnectionBased()) {
                        this.log.debug((Object)"Resetting proxy auth state");
                        proxyAuthState.reset();
                    }
                }
                currentRoute = this.routePlanner.determineRoute(newTarget, currentRequest, (HttpContext)((Object)context2));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Redirecting to '" + uri + "' via " + currentRoute));
                }
                EntityUtils.consume(response2.getEntity());
                response2.close();
            }
            catch (RuntimeException ex) {
                response2.close();
                throw ex;
            }
            catch (IOException ex) {
                response2.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume(response2.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    this.log.debug((Object)"I/O error while releasing connection", (Throwable)ioex);
                    throw ex;
                }
                finally {
                    response2.close();
                }
            }
        }
    }
}

