/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.execchain;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.ProtocolException;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.auth.AuthScope;
import org.apache.storm.shade.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.storm.shade.org.apache.http.client.CredentialsProvider;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.methods.HttpUriRequest;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.client.utils.URIUtils;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.storm.shade.org.apache.http.impl.execchain.ClientExecChain;
import org.apache.storm.shade.org.apache.http.params.HttpParams;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpProcessor;
import org.apache.storm.shade.org.apache.http.util.Args;

@Immutable
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain requestExecutor, HttpProcessor httpProcessor) {
        Args.notNull((Object)requestExecutor, (String)"HTTP client request executor");
        Args.notNull((Object)httpProcessor, (String)"HTTP protocol processor");
        this.requestExecutor = requestExecutor;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route2) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (uri != null) {
                if (route2.getProxyHost() != null && !route2.isTunnelled()) {
                    if (!uri.isAbsolute()) {
                        HttpHost target = route2.getTargetHost();
                        uri = URIUtils.rewriteURI(uri, target, true);
                    } else {
                        uri = URIUtils.rewriteURI(uri);
                    }
                } else {
                    uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, true) : URIUtils.rewriteURI(uri);
                }
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        String userinfo;
        URI uri;
        block17: {
            Args.notNull((Object)route2, (String)"HTTP route");
            Args.notNull((Object)request, (String)"HTTP request");
            Args.notNull((Object)((Object)context2), (String)"HTTP context");
            HttpRequest original = request.getOriginal();
            uri = null;
            if (original instanceof HttpUriRequest) {
                uri = ((HttpUriRequest)original).getURI();
            } else {
                String uriString = original.getRequestLine().getUri();
                try {
                    uri = URI.create(uriString);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isDebugEnabled()) break block17;
                    this.log.debug((Object)("Unable to parse '" + uriString + "' as a valid URI; " + "request URI and Host header may be inconsistent"), (Throwable)ex);
                }
            }
        }
        request.setURI(uri);
        this.rewriteRequestURI(request, route2);
        HttpParams params2 = request.getParams();
        HttpHost virtualHost = (HttpHost)params2.getParameter("http.virtual-host");
        if (virtualHost != null && virtualHost.getPort() == -1) {
            int port = route2.getTargetHost().getPort();
            if (port != -1) {
                virtualHost = new HttpHost(virtualHost.getHostName(), port, virtualHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using virtual host" + virtualHost));
            }
        }
        HttpHost target = null;
        if (virtualHost != null) {
            target = virtualHost;
        } else if (uri != null && uri.isAbsolute() && uri.getHost() != null) {
            target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        if (target == null) {
            target = route2.getTargetHost();
        }
        if (uri != null && (userinfo = uri.getUserInfo()) != null) {
            CredentialsProvider credsProvider = context2.getCredentialsProvider();
            if (credsProvider == null) {
                credsProvider = new BasicCredentialsProvider();
                context2.setCredentialsProvider(credsProvider);
            }
            credsProvider.setCredentials(new AuthScope(target), new UsernamePasswordCredentials(userinfo));
        }
        context2.setAttribute("http.target_host", target);
        context2.setAttribute("http.route", route2);
        context2.setAttribute("http.request", request);
        this.httpProcessor.process(request, (HttpContext)((Object)context2));
        CloseableHttpResponse response2 = this.requestExecutor.execute(route2, request, context2, execAware);
        try {
            context2.setAttribute("http.response", response2);
            this.httpProcessor.process(response2, (HttpContext)((Object)context2));
            return response2;
        }
        catch (RuntimeException ex) {
            response2.close();
            throw ex;
        }
        catch (IOException ex) {
            response2.close();
            throw ex;
        }
        catch (HttpException ex) {
            response2.close();
            throw ex;
        }
    }
}

