/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.ConnectionReuseStrategy;
import org.apache.storm.shade.org.apache.http.HttpClientConnection;
import org.apache.storm.shade.org.apache.http.HttpEntity;
import org.apache.storm.shade.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpRequestInterceptor;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.auth.AuthProtocolState;
import org.apache.storm.shade.org.apache.http.auth.AuthState;
import org.apache.storm.shade.org.apache.http.client.AuthenticationStrategy;
import org.apache.storm.shade.org.apache.http.client.NonRepeatableRequestException;
import org.apache.storm.shade.org.apache.http.client.UserTokenHandler;
import org.apache.storm.shade.org.apache.http.client.config.RequestConfig;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.storm.shade.org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.storm.shade.org.apache.http.conn.ConnectionRequest;
import org.apache.storm.shade.org.apache.http.conn.HttpClientConnectionManager;
import org.apache.storm.shade.org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRouteDirector;
import org.apache.storm.shade.org.apache.http.conn.routing.RouteTracker;
import org.apache.storm.shade.org.apache.http.entity.BufferedHttpEntity;
import org.apache.storm.shade.org.apache.http.impl.auth.HttpAuthenticator;
import org.apache.storm.shade.org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.storm.shade.org.apache.http.impl.execchain.ClientExecChain;
import org.apache.storm.shade.org.apache.http.impl.execchain.ConnectionHolder;
import org.apache.storm.shade.org.apache.http.impl.execchain.Proxies;
import org.apache.storm.shade.org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.storm.shade.org.apache.http.impl.execchain.TunnelRefusedException;
import org.apache.storm.shade.org.apache.http.message.BasicHttpRequest;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpProcessor;
import org.apache.storm.shade.org.apache.http.protocol.HttpRequestExecutor;
import org.apache.storm.shade.org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.storm.shade.org.apache.http.protocol.RequestTargetHost;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.apache.storm.shade.org.apache.http.util.EntityUtils;

@Immutable
public class MainClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final UserTokenHandler userTokenHandler;
    private final HttpRouteDirector routeDirector;

    public MainClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        Args.notNull((Object)requestExecutor, (String)"HTTP request executor");
        Args.notNull((Object)connManager, (String)"Client connection manager");
        Args.notNull((Object)reuseStrategy, (String)"Connection reuse strategy");
        Args.notNull((Object)keepAliveStrategy, (String)"Connection keep alive strategy");
        Args.notNull((Object)targetAuthStrategy, (String)"Target authentication strategy");
        Args.notNull((Object)proxyAuthStrategy, (String)"Proxy authentication strategy");
        Args.notNull((Object)userTokenHandler, (String)"User token handler");
        this.authenticator = new HttpAuthenticator();
        this.proxyHttpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestTargetHost(), new RequestClientConnControl()});
        this.routeDirector = new BasicRouteDirector();
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
        this.targetAuthStrategy = targetAuthStrategy;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.userTokenHandler = userTokenHandler;
    }

    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        AuthState proxyAuthState;
        Args.notNull((Object)route2, (String)"HTTP route");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)((Object)context2), (String)"HTTP context");
        AuthState targetAuthState = context2.getTargetAuthState();
        if (targetAuthState == null) {
            targetAuthState = new AuthState();
            context2.setAttribute("http.auth.target-scope", targetAuthState);
        }
        if ((proxyAuthState = context2.getProxyAuthState()) == null) {
            proxyAuthState = new AuthState();
            context2.setAttribute("http.auth.proxy-scope", proxyAuthState);
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            Proxies.enhanceEntity((HttpEntityEnclosingRequest)((Object)request));
        }
        Object userToken = context2.getUserToken();
        ConnectionRequest connRequest = this.connManager.requestConnection(route2, userToken);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config2 = context2.getRequestConfig();
        try {
            int timeout = config2.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        context2.setAttribute("http.connection", managedConn);
        if (config2.isStaleConnectionCheckEnabled() && managedConn.isOpen()) {
            this.log.debug((Object)"Stale connection check");
            if (managedConn.isStale()) {
                this.log.debug((Object)"Stale connection detected");
                managedConn.close();
            }
        }
        ConnectionHolder connHolder = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            HttpEntity entity;
            HttpResponse response2;
            if (execAware != null) {
                execAware.setCancellable(connHolder);
            }
            int execCount = 1;
            while (true) {
                int timeout;
                if (execCount > 1 && !Proxies.isRepeatable(request)) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (!managedConn.isOpen()) {
                    this.log.debug((Object)("Opening connection " + route2));
                    try {
                        this.establishRoute(proxyAuthState, managedConn, route2, request, context2);
                    }
                    catch (TunnelRefusedException ex) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)ex.getMessage());
                        }
                        response2 = ex.getResponse();
                        break;
                    }
                }
                if ((timeout = config2.getSocketTimeout()) >= 0) {
                    managedConn.setSocketTimeout(timeout);
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Executing request " + request.getRequestLine()));
                }
                if (!request.containsHeader("Authorization")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Target auth state: " + (Object)((Object)targetAuthState.getState())));
                    }
                    this.authenticator.generateAuthResponse(request, targetAuthState, (HttpContext)((Object)context2));
                }
                if (!request.containsHeader("Proxy-Authorization") && !route2.isTunnelled()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Proxy auth state: " + (Object)((Object)proxyAuthState.getState())));
                    }
                    this.authenticator.generateAuthResponse(request, proxyAuthState, (HttpContext)((Object)context2));
                }
                if (this.reuseStrategy.keepAlive(response2 = this.requestExecutor.execute(request, managedConn, (HttpContext)((Object)context2)), (HttpContext)((Object)context2))) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response2, (HttpContext)((Object)context2));
                    if (this.log.isDebugEnabled()) {
                        String s = duration > 0L ? "for " + duration + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                        this.log.debug((Object)("Connection can be kept alive " + s));
                    }
                    connHolder.setValidFor(duration, TimeUnit.MILLISECONDS);
                    connHolder.markReusable();
                } else {
                    connHolder.markNonReusable();
                }
                if (!this.needAuthentication(targetAuthState, proxyAuthState, route2, response2, context2)) break;
                HttpEntity entity2 = response2.getEntity();
                if (connHolder.isReusable()) {
                    EntityUtils.consume(entity2);
                } else {
                    managedConn.close();
                    if (proxyAuthState.getState() == AuthProtocolState.SUCCESS && proxyAuthState.getAuthScheme() != null && proxyAuthState.getAuthScheme().isConnectionBased()) {
                        this.log.debug((Object)"Resetting proxy auth state");
                        proxyAuthState.reset();
                    }
                    if (targetAuthState.getState() == AuthProtocolState.SUCCESS && targetAuthState.getAuthScheme() != null && targetAuthState.getAuthScheme().isConnectionBased()) {
                        this.log.debug((Object)"Resetting target auth state");
                        targetAuthState.reset();
                    }
                }
                HttpRequest original = request.getOriginal();
                if (!original.containsHeader("Authorization")) {
                    request.removeHeaders("Authorization");
                }
                if (!original.containsHeader("Proxy-Authorization")) {
                    request.removeHeaders("Proxy-Authorization");
                }
                ++execCount;
            }
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken((HttpContext)((Object)context2));
                context2.setAttribute("http.user-token", userToken);
            }
            if (userToken != null) {
                connHolder.setState(userToken);
            }
            if ((entity = response2.getEntity()) == null || !entity.isStreaming()) {
                connHolder.releaseConnection();
                return Proxies.enhanceResponse(response2, null);
            }
            return Proxies.enhanceResponse(response2, connHolder);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            connHolder.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            connHolder.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            connHolder.abortConnection();
            throw ex;
        }
    }

    void establishRoute(AuthState proxyAuthState, HttpClientConnection managedConn, HttpRoute route2, HttpRequest request, HttpClientContext context2) throws HttpException, IOException {
        int step;
        RequestConfig config2 = context2.getRequestConfig();
        int timeout = config2.getConnectTimeout();
        RouteTracker tracker2 = new RouteTracker(route2);
        do {
            HttpRoute fact = tracker2.toRoute();
            step = this.routeDirector.nextStep(route2, fact);
            switch (step) {
                case 1: {
                    this.connManager.connect(managedConn, route2, timeout > 0 ? timeout : 0, (HttpContext)((Object)context2));
                    tracker2.connectTarget(route2.isSecure());
                    break;
                }
                case 2: {
                    this.connManager.connect(managedConn, route2, timeout > 0 ? timeout : 0, (HttpContext)((Object)context2));
                    HttpHost proxy2 = route2.getProxyHost();
                    tracker2.connectProxy(proxy2, false);
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnelToTarget(proxyAuthState, managedConn, route2, request, context2);
                    this.log.debug((Object)"Tunnel to target created.");
                    tracker2.tunnelTarget(secure);
                    break;
                }
                case 4: {
                    int hop = fact.getHopCount() - 1;
                    boolean secure = this.createTunnelToProxy(route2, hop, context2);
                    this.log.debug((Object)"Tunnel to proxy created.");
                    tracker2.tunnelProxy(route2.getHopTarget(hop), secure);
                    break;
                }
                case 5: {
                    this.connManager.upgrade(managedConn, route2, (HttpContext)((Object)context2));
                    tracker2.layerProtocol(route2.isSecure());
                    break;
                }
                case -1: {
                    throw new HttpException("Unable to establish route: planned = " + route2 + "; current = " + fact);
                }
                case 0: {
                    this.connManager.routeComplete(managedConn, route2, (HttpContext)((Object)context2));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    private boolean createTunnelToTarget(AuthState proxyAuthState, HttpClientConnection managedConn, HttpRoute route2, HttpRequest request, HttpClientContext context2) throws HttpException, IOException {
        HttpEntity entity;
        int status2;
        HttpResponse response2;
        RequestConfig config2 = context2.getRequestConfig();
        int timeout = config2.getConnectTimeout();
        HttpHost target = route2.getTargetHost();
        HttpHost proxy2 = route2.getProxyHost();
        String authority = target.toHostString();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", authority, request.getProtocolVersion());
        this.requestExecutor.preProcess(connect, this.proxyHttpProcessor, (HttpContext)((Object)context2));
        while (true) {
            if (!managedConn.isOpen()) {
                this.connManager.connect(managedConn, route2, timeout > 0 ? timeout : 0, (HttpContext)((Object)context2));
            }
            connect.removeHeaders("Proxy-Authorization");
            this.authenticator.generateAuthResponse(connect, proxyAuthState, (HttpContext)((Object)context2));
            response2 = this.requestExecutor.execute(connect, managedConn, (HttpContext)((Object)context2));
            status2 = response2.getStatusLine().getStatusCode();
            if (status2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response2.getStatusLine());
            }
            if (!config2.isAuthenticationEnabled()) continue;
            if (!this.authenticator.isAuthenticationRequested(proxy2, response2, this.proxyAuthStrategy, proxyAuthState, (HttpContext)((Object)context2)) || !this.authenticator.handleAuthChallenge(proxy2, response2, this.proxyAuthStrategy, proxyAuthState, (HttpContext)((Object)context2))) break;
            if (this.reuseStrategy.keepAlive(response2, (HttpContext)((Object)context2))) {
                this.log.debug((Object)"Connection kept alive");
                entity = response2.getEntity();
                EntityUtils.consume(entity);
                continue;
            }
            managedConn.close();
        }
        status2 = response2.getStatusLine().getStatusCode();
        if (status2 > 299) {
            entity = response2.getEntity();
            if (entity != null) {
                response2.setEntity(new BufferedHttpEntity(entity));
            }
            managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response2.getStatusLine(), response2);
        }
        return false;
    }

    private boolean createTunnelToProxy(HttpRoute route2, int hop, HttpClientContext context2) throws HttpException {
        throw new HttpException("Proxy chains are not supported.");
    }

    private boolean needAuthentication(AuthState targetAuthState, AuthState proxyAuthState, HttpRoute route2, HttpResponse response2, HttpClientContext context2) {
        RequestConfig config2 = context2.getRequestConfig();
        if (config2.isAuthenticationEnabled()) {
            HttpHost target = context2.getTargetHost();
            if (target == null) {
                target = route2.getTargetHost();
            }
            if (target.getPort() < 0) {
                target = new HttpHost(target.getHostName(), route2.getTargetHost().getPort(), target.getSchemeName());
            }
            boolean targetAuthRequested = this.authenticator.isAuthenticationRequested(target, response2, this.targetAuthStrategy, targetAuthState, (HttpContext)((Object)context2));
            HttpHost proxy2 = route2.getProxyHost();
            if (proxy2 == null) {
                proxy2 = route2.getTargetHost();
            }
            boolean proxyAuthRequested = this.authenticator.isAuthenticationRequested(proxy2, response2, this.proxyAuthStrategy, proxyAuthState, (HttpContext)((Object)context2));
            if (targetAuthRequested) {
                return this.authenticator.handleAuthChallenge(target, response2, this.targetAuthStrategy, targetAuthState, (HttpContext)((Object)context2));
            }
            if (proxyAuthRequested) {
                return this.authenticator.handleAuthChallenge(proxy2, response2, this.proxyAuthStrategy, proxyAuthState, (HttpContext)((Object)context2));
            }
        }
        return false;
    }
}

