/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.cookie.CookieAttributeHandler;
import org.apache.storm.shade.org.apache.http.cookie.CookieSpec;
import org.apache.storm.shade.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap = new HashMap<String, CookieAttributeHandler>(10);

    public void registerAttribHandler(String name, CookieAttributeHandler handler2) {
        Args.notNull((Object)name, (String)"Attribute name");
        Args.notNull((Object)handler2, (String)"Attribute handler");
        this.attribHandlerMap.put(name, handler2);
    }

    protected CookieAttributeHandler findAttribHandler(String name) {
        return this.attribHandlerMap.get(name);
    }

    protected CookieAttributeHandler getAttribHandler(String name) {
        CookieAttributeHandler handler2 = this.findAttribHandler(name);
        if (handler2 == null) {
            throw new IllegalStateException("Handler not registered for " + name + " attribute.");
        }
        return handler2;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

