/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.conn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.util.Args;

@Immutable
public class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log2, String id) {
        this.log = log2;
        this.id = id;
    }

    public Wire(Log log2) {
        this(log2, "");
    }

    private void wire(String header2, InputStream instream) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = instream.read()) != -1) {
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header2);
                this.log.debug((Object)(this.id + " " + buffer.toString()));
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header2);
            this.log.debug((Object)(this.id + " " + buffer.toString()));
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output");
        this.wire(">> ", outstream);
    }

    public void input(InputStream instream) throws IOException {
        Args.notNull((Object)instream, (String)"Input");
        this.wire("<< ", instream);
    }

    public void output(byte[] b, int off, int len) throws IOException {
        Args.notNull((Object)b, (String)"Output");
        this.wire(">> ", new ByteArrayInputStream(b, off, len));
    }

    public void input(byte[] b, int off, int len) throws IOException {
        Args.notNull((Object)b, (String)"Input");
        this.wire("<< ", new ByteArrayInputStream(b, off, len));
    }

    public void output(byte[] b) throws IOException {
        Args.notNull((Object)b, (String)"Output");
        this.wire(">> ", new ByteArrayInputStream(b));
    }

    public void input(byte[] b) throws IOException {
        Args.notNull((Object)b, (String)"Input");
        this.wire("<< ", new ByteArrayInputStream(b));
    }

    public void output(int b) throws IOException {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) throws IOException {
        this.input(new byte[]{(byte)b});
    }

    public void output(String s) throws IOException {
        Args.notNull((Object)s, (String)"Output");
        this.output(s.getBytes());
    }

    public void input(String s) throws IOException {
        Args.notNull((Object)s, (String)"Input");
        this.input(s.getBytes());
    }
}

