/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.conn.params.ConnRouteParams;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.storm.shade.org.apache.http.conn.scheme.Scheme;
import org.apache.storm.shade.org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.apache.storm.shade.org.apache.http.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@NotThreadSafe
public class ProxySelectorRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;
    protected ProxySelector proxySelector;

    public ProxySelectorRoutePlanner(SchemeRegistry schreg, ProxySelector prosel) {
        Args.notNull((Object)schreg, (String)"SchemeRegistry");
        this.schemeRegistry = schreg;
        this.proxySelector = prosel;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector prosel) {
        this.proxySelector = prosel;
    }

    @Override
    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context2) throws HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        HttpRoute route2 = ConnRouteParams.getForcedRoute(request.getParams());
        if (route2 != null) {
            return route2;
        }
        Asserts.notNull((Object)target, (String)"Target host");
        InetAddress local2 = ConnRouteParams.getLocalAddress(request.getParams());
        HttpHost proxy2 = this.determineProxy(target, request, context2);
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        boolean secure = schm.isLayered();
        route2 = proxy2 == null ? new HttpRoute(target, local2, secure) : new HttpRoute(target, local2, proxy2, secure);
        return route2;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context2) throws HttpException {
        ProxySelector psel = this.proxySelector;
        if (psel == null) {
            psel = ProxySelector.getDefault();
        }
        if (psel == null) {
            return null;
        }
        URI targetURI = null;
        try {
            targetURI = new URI(target.toURI());
        }
        catch (URISyntaxException usx) {
            throw new HttpException("Cannot convert host to URI: " + target, usx);
        }
        List<Proxy> proxies = psel.select(targetURI);
        Proxy p = this.chooseProxy(proxies, target, request, context2);
        HttpHost result2 = null;
        if (p.type() == Proxy.Type.HTTP) {
            if (!(p.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + p.address());
            }
            InetSocketAddress isa = (InetSocketAddress)p.address();
            result2 = new HttpHost(this.getHost(isa), isa.getPort());
        }
        return result2;
    }

    protected String getHost(InetSocketAddress isa) {
        return isa.isUnresolved() ? isa.getHostName() : isa.getAddress().getHostAddress();
    }

    protected Proxy chooseProxy(List<Proxy> proxies, HttpHost target, HttpRequest request, HttpContext context2) {
        Args.notEmpty(proxies, (String)"List of proxies");
        Proxy result2 = null;
        block3: for (int i = 0; result2 == null && i < proxies.size(); ++i) {
            Proxy p = proxies.get(i);
            switch (p.type()) {
                case DIRECT: 
                case HTTP: {
                    result2 = p;
                    continue block3;
                }
            }
        }
        if (result2 == null) {
            result2 = Proxy.NO_PROXY;
        }
        return result2;
    }
}

