/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.config.MessageConstraints;
import org.apache.storm.shade.org.apache.http.entity.ContentLengthStrategy;
import org.apache.storm.shade.org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.storm.shade.org.apache.http.impl.conn.LoggingInputStream;
import org.apache.storm.shade.org.apache.http.impl.conn.LoggingOutputStream;
import org.apache.storm.shade.org.apache.http.impl.conn.Wire;
import org.apache.storm.shade.org.apache.http.io.HttpMessageParserFactory;
import org.apache.storm.shade.org.apache.http.io.HttpMessageWriterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class LoggingManagedHttpClientConnection
extends DefaultManagedHttpClientConnection {
    private final Log log;
    private final Log headerlog;
    private final Wire wire;

    public LoggingManagedHttpClientConnection(String id, Log log2, Log headerlog, Log wirelog, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(id, buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.log = log2;
        this.headerlog = headerlog;
        this.wire = new Wire(wirelog, id);
    }

    @Override
    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": Close connection"));
        }
        super.close();
    }

    @Override
    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": Shutdown connection"));
        }
        super.shutdown();
    }

    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        InputStream in = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            in = new LoggingInputStream(in, this.wire);
        }
        return in;
    }

    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        OutputStream out = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            out = new LoggingOutputStream(out, this.wire);
        }
        return out;
    }

    protected void onResponseReceived(HttpResponse response2) {
        if (response2 != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug((Object)(this.getId() + " << " + response2.getStatusLine().toString()));
            for (Header header2 : headers = response2.getAllHeaders()) {
                this.headerlog.debug((Object)(this.getId() + " << " + header2.toString()));
            }
        }
    }

    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug((Object)(this.getId() + " >> " + request.getRequestLine().toString()));
            for (Header header2 : headers = request.getAllHeaders()) {
                this.headerlog.debug((Object)(this.getId() + " >> " + header2.toString()));
            }
        }
    }
}

