/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.conn;

import java.net.InetAddress;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.client.config.RequestConfig;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.conn.SchemePortResolver;
import org.apache.storm.shade.org.apache.http.conn.UnsupportedSchemeException;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.storm.shade.org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context2) throws HttpException {
        HttpHost target;
        Args.notNull((Object)host, (String)"Target host");
        Args.notNull((Object)request, (String)"Request");
        HttpClientContext clientContext = HttpClientContext.adapt(context2);
        RequestConfig config2 = clientContext.getRequestConfig();
        InetAddress local2 = config2.getLocalAddress();
        HttpHost proxy2 = config2.getProxy();
        if (proxy2 == null) {
            proxy2 = this.determineProxy(host, request, context2);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy2 == null) {
            return new HttpRoute(target, local2, secure);
        }
        return new HttpRoute(target, local2, proxy2, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context2) throws HttpException {
        return null;
    }
}

