/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.conn.ClientConnectionOperator;
import org.apache.storm.shade.org.apache.http.conn.OperatedClientConnection;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.routing.RouteTracker;
import org.apache.storm.shade.org.apache.http.params.HttpParams;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.apache.storm.shade.org.apache.http.util.Asserts;

@Deprecated
public abstract class AbstractPoolEntry {
    protected final ClientConnectionOperator connOperator;
    protected final OperatedClientConnection connection;
    protected volatile HttpRoute route;
    protected volatile Object state;
    protected volatile RouteTracker tracker;

    protected AbstractPoolEntry(ClientConnectionOperator connOperator, HttpRoute route2) {
        Args.notNull((Object)connOperator, (String)"Connection operator");
        this.connOperator = connOperator;
        this.connection = connOperator.createConnection();
        this.route = route2;
        this.tracker = null;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(Object state) {
        this.state = state;
    }

    public void open(HttpRoute route2, HttpContext context2, HttpParams params2) throws IOException {
        Args.notNull((Object)route2, (String)"Route");
        Args.notNull((Object)params2, (String)"HTTP parameters");
        if (this.tracker != null) {
            Asserts.check((!this.tracker.isConnected() ? 1 : 0) != 0, (String)"Connection already open");
        }
        this.tracker = new RouteTracker(route2);
        HttpHost proxy2 = route2.getProxyHost();
        this.connOperator.openConnection(this.connection, proxy2 != null ? proxy2 : route2.getTargetHost(), route2.getLocalAddress(), context2, params2);
        RouteTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new InterruptedIOException("Request aborted");
        }
        if (proxy2 == null) {
            localTracker.connectTarget(this.connection.isSecure());
        } else {
            localTracker.connectProxy(proxy2, this.connection.isSecure());
        }
    }

    public void tunnelTarget(boolean secure, HttpParams params2) throws IOException {
        Args.notNull((Object)params2, (String)"HTTP parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        Asserts.check((!this.tracker.isTunnelled() ? 1 : 0) != 0, (String)"Connection is already tunnelled");
        this.connection.update(null, this.tracker.getTargetHost(), secure, params2);
        this.tracker.tunnelTarget(secure);
    }

    public void tunnelProxy(HttpHost next, boolean secure, HttpParams params2) throws IOException {
        Args.notNull((Object)next, (String)"Next proxy");
        Args.notNull((Object)params2, (String)"Parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        this.connection.update(null, next, secure, params2);
        this.tracker.tunnelProxy(next, secure);
    }

    public void layerProtocol(HttpContext context2, HttpParams params2) throws IOException {
        Args.notNull((Object)params2, (String)"HTTP parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        Asserts.check((boolean)this.tracker.isTunnelled(), (String)"Protocol layering without a tunnel not supported");
        Asserts.check((!this.tracker.isLayered() ? 1 : 0) != 0, (String)"Multiple protocol layering not supported");
        HttpHost target = this.tracker.getTargetHost();
        this.connOperator.updateSecureConnection(this.connection, target, context2, params2);
        this.tracker.layerProtocol(this.connection.isSecure());
    }

    protected void shutdownEntry() {
        this.tracker = null;
        this.state = null;
    }
}

