/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.annotation.ThreadSafe;
import org.apache.storm.shade.org.apache.http.client.ClientProtocolException;
import org.apache.storm.shade.org.apache.http.client.config.RequestConfig;
import org.apache.storm.shade.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.storm.shade.org.apache.http.client.methods.Configurable;
import org.apache.storm.shade.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.storm.shade.org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.conn.ClientConnectionManager;
import org.apache.storm.shade.org.apache.http.conn.ClientConnectionRequest;
import org.apache.storm.shade.org.apache.http.conn.HttpClientConnectionManager;
import org.apache.storm.shade.org.apache.http.conn.ManagedClientConnection;
import org.apache.storm.shade.org.apache.http.conn.routing.HttpRoute;
import org.apache.storm.shade.org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.storm.shade.org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.storm.shade.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.storm.shade.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.storm.shade.org.apache.http.impl.execchain.MinimalClientExec;
import org.apache.storm.shade.org.apache.http.params.BasicHttpParams;
import org.apache.storm.shade.org.apache.http.params.HttpParams;
import org.apache.storm.shade.org.apache.http.protocol.BasicHttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpRequestExecutor;
import org.apache.storm.shade.org.apache.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = (HttpClientConnectionManager)Args.notNull((Object)connManager, (String)"HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context2) throws IOException, ClientProtocolException {
        Args.notNull((Object)target, (String)"Target host");
        Args.notNull((Object)request, (String)"HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context2 != null ? context2 : new BasicHttpContext());
            HttpRoute route2 = new HttpRoute(target);
            RequestConfig config2 = null;
            if (request instanceof Configurable) {
                config2 = ((Configurable)((Object)request)).getConfig();
            }
            if (config2 != null) {
                localcontext.setRequestConfig(config2);
            }
            return this.requestExecutor.execute(route2, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route2, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

