/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.client;

import java.io.IOException;
import java.net.URI;
import org.apache.storm.shade.org.apache.http.HttpEntity;
import org.apache.storm.shade.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpRequestInterceptor;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpResponseInterceptor;
import org.apache.storm.shade.org.apache.http.client.ClientProtocolException;
import org.apache.storm.shade.org.apache.http.client.HttpClient;
import org.apache.storm.shade.org.apache.http.client.ResponseHandler;
import org.apache.storm.shade.org.apache.http.client.methods.HttpUriRequest;
import org.apache.storm.shade.org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.storm.shade.org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.storm.shade.org.apache.http.client.utils.URIUtils;
import org.apache.storm.shade.org.apache.http.conn.ClientConnectionManager;
import org.apache.storm.shade.org.apache.http.impl.client.DefaultHttpClient;
import org.apache.storm.shade.org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.storm.shade.org.apache.http.impl.client.RequestWrapper;
import org.apache.storm.shade.org.apache.http.params.HttpParams;
import org.apache.storm.shade.org.apache.http.protocol.BasicHttpContext;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DecompressingHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final HttpRequestInterceptor acceptEncodingInterceptor;
    private final HttpResponseInterceptor contentEncodingInterceptor;

    public DecompressingHttpClient() {
        this(new DefaultHttpClient());
    }

    public DecompressingHttpClient(HttpClient backend) {
        this(backend, new RequestAcceptEncoding(), new ResponseContentEncoding());
    }

    DecompressingHttpClient(HttpClient backend, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
        this.backend = backend;
        this.acceptEncodingInterceptor = requestInterceptor;
        this.contentEncodingInterceptor = responseInterceptor;
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request), (HttpRequest)request, (HttpContext)null);
    }

    public HttpClient getHttpClient() {
        return this.backend;
    }

    HttpHost getHttpHost(HttpUriRequest request) {
        URI uri = request.getURI();
        return URIUtils.extractHost(uri);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request, HttpContext context2) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request), (HttpRequest)request, context2);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.execute(target, request, (HttpContext)null);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context2) throws IOException, ClientProtocolException {
        try {
            HttpContext localContext = context2 != null ? context2 : new BasicHttpContext();
            RequestWrapper wrapped = request instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request) : new RequestWrapper(request);
            this.acceptEncodingInterceptor.process(wrapped, localContext);
            HttpResponse response2 = this.backend.execute(target, (HttpRequest)wrapped, localContext);
            try {
                this.contentEncodingInterceptor.process(response2, localContext);
                if (Boolean.TRUE.equals(localContext.getAttribute("http.client.response.uncompressed"))) {
                    response2.removeHeaders("Content-Length");
                    response2.removeHeaders("Content-Encoding");
                    response2.removeHeaders("Content-MD5");
                }
                return response2;
            }
            catch (HttpException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
            catch (IOException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
            catch (RuntimeException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
        }
        catch (HttpException e) {
            throw new ClientProtocolException(e);
        }
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request), (HttpRequest)request, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context2) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request), request, responseHandler, context2);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context2) throws IOException, ClientProtocolException {
        HttpResponse response2 = this.execute(target, request, context2);
        try {
            T t = responseHandler.handleResponse(response2);
            return t;
        }
        finally {
            HttpEntity entity = response2.getEntity();
            if (entity != null) {
                EntityUtils.consume(entity);
            }
        }
    }
}

