/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.client;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.auth.AuthOption;
import org.apache.storm.shade.org.apache.http.auth.AuthScheme;
import org.apache.storm.shade.org.apache.http.auth.AuthScope;
import org.apache.storm.shade.org.apache.http.auth.AuthenticationException;
import org.apache.storm.shade.org.apache.http.auth.Credentials;
import org.apache.storm.shade.org.apache.http.auth.MalformedChallengeException;
import org.apache.storm.shade.org.apache.http.client.AuthCache;
import org.apache.storm.shade.org.apache.http.client.AuthenticationHandler;
import org.apache.storm.shade.org.apache.http.client.AuthenticationStrategy;
import org.apache.storm.shade.org.apache.http.client.CredentialsProvider;
import org.apache.storm.shade.org.apache.http.impl.client.BasicAuthCache;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Immutable
class AuthenticationStrategyAdaptor
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthenticationHandler handler;

    public AuthenticationStrategyAdaptor(AuthenticationHandler handler2) {
        this.handler = handler2;
    }

    @Override
    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response2, HttpContext context2) {
        return this.handler.isAuthenticationRequested(response2, context2);
    }

    @Override
    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response2, HttpContext context2) throws MalformedChallengeException {
        return this.handler.getChallenges(response2, context2);
    }

    @Override
    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response2, HttpContext context2) throws MalformedChallengeException {
        AuthScheme authScheme;
        Args.notNull(challenges, (String)"Map of auth challenges");
        Args.notNull((Object)authhost, (String)"Host");
        Args.notNull((Object)response2, (String)"HTTP response");
        Args.notNull((Object)context2, (String)"HTTP context");
        LinkedList<AuthOption> options = new LinkedList<AuthOption>();
        CredentialsProvider credsProvider = (CredentialsProvider)context2.getAttribute("http.auth.credentials-provider");
        if (credsProvider == null) {
            this.log.debug((Object)"Credentials provider not set in the context");
            return options;
        }
        try {
            authScheme = this.handler.selectScheme(challenges, response2, context2);
        }
        catch (AuthenticationException ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            return options;
        }
        String id = authScheme.getSchemeName();
        Header challenge = challenges.get(id.toLowerCase(Locale.US));
        authScheme.processChallenge(challenge);
        AuthScope authScope = new AuthScope(authhost.getHostName(), authhost.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
        Credentials credentials = credsProvider.getCredentials(authScope);
        if (credentials != null) {
            options.add(new AuthOption(authScheme, credentials));
        }
        return options;
    }

    @Override
    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context2) {
        AuthCache authCache = (AuthCache)context2.getAttribute("http.auth.auth-cache");
        if (this.isCachable(authScheme)) {
            if (authCache == null) {
                authCache = new BasicAuthCache();
                context2.setAttribute("http.auth.auth-cache", authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + authhost));
            }
            authCache.put(authhost, authScheme);
        }
    }

    @Override
    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context2) {
        AuthCache authCache = (AuthCache)context2.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing from cache '" + authScheme.getSchemeName() + "' auth scheme for " + authhost));
        }
        authCache.remove(authhost);
    }

    private boolean isCachable(AuthScheme authScheme) {
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("Basic") || schemeName.equalsIgnoreCase("Digest");
    }

    public AuthenticationHandler getHandler() {
        return this.handler;
    }
}

