/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.FormattedHeader;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.auth.AuthScheme;
import org.apache.storm.shade.org.apache.http.auth.AuthSchemeRegistry;
import org.apache.storm.shade.org.apache.http.auth.AuthenticationException;
import org.apache.storm.shade.org.apache.http.auth.MalformedChallengeException;
import org.apache.storm.shade.org.apache.http.client.AuthenticationHandler;
import org.apache.storm.shade.org.apache.http.protocol.HTTP;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Asserts;
import org.apache.storm.shade.org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Immutable
public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("negotiate", "NTLM", "Digest", "Basic"));

    protected Map<String, Header> parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (Header header2 : headers) {
            int pos;
            CharArrayBuffer buffer;
            if (header2 instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header2).getBuffer();
                pos = ((FormattedHeader)header2).getValuePos();
            } else {
                String s = header2.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(Locale.US), header2);
        }
        return map;
    }

    protected List<String> getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    protected List<String> getAuthPreferences(HttpResponse response2, HttpContext context2) {
        return this.getAuthPreferences();
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> challenges, HttpResponse response2, HttpContext context2) throws AuthenticationException {
        AuthSchemeRegistry registry = (AuthSchemeRegistry)context2.getAttribute("http.authscheme-registry");
        Asserts.notNull((Object)registry, (String)"AuthScheme registry");
        List<String> authPrefs = this.getAuthPreferences(response2, context2);
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication schemes in the order of preference: " + authPrefs));
        }
        AuthScheme authScheme = null;
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase(Locale.ENGLISH));
            if (challenge != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(id + " authentication scheme selected"));
                }
                try {
                    authScheme = registry.getAuthScheme(id, response2.getParams());
                    break;
                }
                catch (IllegalStateException e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("Authentication scheme " + id + " not supported"));
                    continue;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }
}

