/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl.auth;

import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.auth.AuthenticationException;
import org.apache.storm.shade.org.apache.http.auth.Credentials;
import org.apache.storm.shade.org.apache.http.impl.auth.GGSSchemeBase;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
        super(false);
    }

    public String getSchemeName() {
        return "Kerberos";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context2) throws AuthenticationException {
        return super.authenticate(credentials, request, context2);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer);
    }

    public String getParameter(String name) {
        Args.notNull((Object)name, (String)"Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

