/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.storm.shade.org.apache.http.annotation.NotThreadSafe;
import org.apache.storm.shade.org.apache.http.impl.SocketHttpServerConnection;
import org.apache.storm.shade.org.apache.http.params.HttpConnectionParams;
import org.apache.storm.shade.org.apache.http.params.HttpParams;

@NotThreadSafe
public class DefaultHttpServerConnection
extends SocketHttpServerConnection {
    public void bind(Socket socket, HttpParams params2) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params2));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params2));
        socket.setKeepAlive(HttpConnectionParams.getSoKeepalive(params2));
        int linger = HttpConnectionParams.getLinger(params2);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params2);
    }
}

