/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl;

import java.util.Locale;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpResponseFactory;
import org.apache.storm.shade.org.apache.http.ProtocolVersion;
import org.apache.storm.shade.org.apache.http.ReasonPhraseCatalog;
import org.apache.storm.shade.org.apache.http.StatusLine;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.storm.shade.org.apache.http.message.BasicHttpResponse;
import org.apache.storm.shade.org.apache.http.message.BasicStatusLine;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = catalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status2, HttpContext context2) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        Locale loc = this.determineLocale(context2);
        String reason = this.reasonCatalog.getReason(status2, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status2, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context2) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale loc = this.determineLocale(context2);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    protected Locale determineLocale(HttpContext context2) {
        return Locale.getDefault();
    }
}

