/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.impl;

import org.apache.storm.shade.org.apache.http.ConnectionReuseStrategy;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HeaderIterator;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpVersion;
import org.apache.storm.shade.org.apache.http.ParseException;
import org.apache.storm.shade.org.apache.http.ProtocolVersion;
import org.apache.storm.shade.org.apache.http.TokenIterator;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.message.BasicTokenIterator;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public boolean keepAlive(HttpResponse response2, HttpContext context2) {
        HeaderIterator hit;
        ProtocolVersion ver;
        block17: {
            if (response2 == null) {
                throw new IllegalArgumentException("HTTP response may not be null.");
            }
            if (context2 == null) {
                throw new IllegalArgumentException("HTTP context may not be null.");
            }
            ver = response2.getStatusLine().getProtocolVersion();
            Header teh = response2.getFirstHeader("Transfer-Encoding");
            if (teh != null) {
                if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(response2)) {
                Header[] clhs = response2.getHeaders("Content-Length");
                if (clhs.length == 1) {
                    Header clh = clhs[0];
                    try {
                        int contentLen = Integer.parseInt(clh.getValue());
                        if (contentLen < 0) {
                            return false;
                        }
                        break block17;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(hit = response2.headerIterator("Connection")).hasNext()) {
            hit = response2.headerIterator("Proxy-Connection");
        }
        if (hit.hasNext()) {
            try {
                TokenIterator ti = this.createTokenIterator(hit);
                boolean keepalive = false;
                while (ti.hasNext()) {
                    String token = ti.nextToken();
                    if ("Close".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(token)) continue;
                    keepalive = true;
                }
                if (keepalive) {
                    return true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpResponse response2) {
        int status2 = response2.getStatusLine().getStatusCode();
        return status2 >= 200 && status2 != 204 && status2 != 304 && status2 != 205;
    }
}

