/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Locale;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HeaderElement;
import org.apache.storm.shade.org.apache.http.HttpEntity;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpResponse;
import org.apache.storm.shade.org.apache.http.HttpResponseInterceptor;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.storm.shade.org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    public void process(HttpResponse response2, HttpContext context2) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response2.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs = ceheader.getElements();
            boolean uncompressed = false;
            int i$ = 0;
            HeaderElement[] arr$ = codecs;
            int len$ = arr$.length;
            if (i$ < len$) {
                HeaderElement codec2 = arr$[i$];
                String codecname = codec2.getName().toLowerCase(Locale.US);
                if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                    response2.setEntity(new GzipDecompressingEntity(response2.getEntity()));
                    uncompressed = true;
                } else if ("deflate".equals(codecname)) {
                    response2.setEntity(new DeflateDecompressingEntity(response2.getEntity()));
                    uncompressed = true;
                } else {
                    if ("identity".equals(codecname)) {
                        return;
                    }
                    throw new HttpException("Unsupported Content-Coding: " + codec2.getName());
                }
            }
            if (uncompressed) {
                response2.removeHeaders("Content-Length");
                response2.removeHeaders("Content-Encoding");
                response2.removeHeaders("Content-MD5");
            }
        }
    }
}

