/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.http.client.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.shade.org.apache.http.Header;
import org.apache.storm.shade.org.apache.http.HttpException;
import org.apache.storm.shade.org.apache.http.HttpHost;
import org.apache.storm.shade.org.apache.http.HttpRequest;
import org.apache.storm.shade.org.apache.http.HttpRequestInterceptor;
import org.apache.storm.shade.org.apache.http.annotation.Immutable;
import org.apache.storm.shade.org.apache.http.client.CookieStore;
import org.apache.storm.shade.org.apache.http.client.config.RequestConfig;
import org.apache.storm.shade.org.apache.http.client.methods.HttpUriRequest;
import org.apache.storm.shade.org.apache.http.client.protocol.HttpClientContext;
import org.apache.storm.shade.org.apache.http.config.Lookup;
import org.apache.storm.shade.org.apache.http.conn.routing.RouteInfo;
import org.apache.storm.shade.org.apache.http.cookie.Cookie;
import org.apache.storm.shade.org.apache.http.cookie.CookieOrigin;
import org.apache.storm.shade.org.apache.http.cookie.CookieSpec;
import org.apache.storm.shade.org.apache.http.cookie.CookieSpecProvider;
import org.apache.storm.shade.org.apache.http.cookie.SetCookie2;
import org.apache.storm.shade.org.apache.http.protocol.HttpContext;
import org.apache.storm.shade.org.apache.http.util.Args;
import org.apache.storm.shade.org.apache.http.util.TextUtils;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context2) throws HttpException, IOException {
        int ver;
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)context2, (String)"HTTP context");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context2);
        CookieStore cookieStore = clientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug((Object)"Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> registry = clientContext.getCookieSpecRegistry();
        if (registry == null) {
            this.log.debug((Object)"CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost targetHost = clientContext.getTargetHost();
        if (targetHost == null) {
            this.log.debug((Object)"Target host not set in the context");
            return;
        }
        RouteInfo route2 = clientContext.getHttpRoute();
        if (route2 == null) {
            this.log.debug((Object)"Connection route not set in the context");
            return;
        }
        RequestConfig config2 = clientContext.getRequestConfig();
        String policy = config2.getCookieSpec();
        if (policy == null) {
            policy = "best-match";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CookieSpec selected: " + policy));
        }
        URI requestURI = null;
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
        String path = requestURI != null ? requestURI.getPath() : null;
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            port = route2.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port >= 0 ? port : 0, !TextUtils.isEmpty((CharSequence)path) ? path : "/", route2.isSecure());
        CookieSpecProvider provider = (CookieSpecProvider)registry.lookup(policy);
        if (provider == null) {
            throw new HttpException("Unsupported cookie policy: " + policy);
        }
        CookieSpec cookieSpec = provider.create((HttpContext)((Object)clientContext));
        ArrayList<Cookie> cookies2 = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now2 = new Date();
        for (Cookie cookie : cookies2) {
            if (!cookie.isExpired(now2)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cookie " + cookie + " match " + cookieOrigin));
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Cookie " + cookie + " expired"));
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header2 : headers) {
                request.addHeader(header2);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header2;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header2 = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header2);
            }
        }
        context2.setAttribute("http.cookie-spec", cookieSpec);
        context2.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

