/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.storm.shade.org.apache.curator.TimeTrace;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.api.Pathable;
import org.apache.storm.shade.org.apache.curator.framework.api.SyncBuilder;
import org.apache.storm.shade.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.storm.shade.org.apache.curator.framework.imps.Backgrounding;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.OperationAndData;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;

public class SyncBuilderImpl
implements SyncBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding = new Backgrounding();

    public SyncBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
    }

    @Override
    public Pathable<Void> inBackground() {
        return this;
    }

    @Override
    public Pathable<Void> inBackground(Object context2) {
        this.backgrounding = new Backgrounding(context2);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback, Object context2) {
        this.backgrounding = new Backgrounding(callback, context2);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback, Executor executor2) {
        this.backgrounding = new Backgrounding(callback, executor2);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback, Object context2, Executor executor2) {
        this.backgrounding = new Backgrounding(this.client, callback, context2, executor2);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace2 = this.client.getZookeeperClient().startTracer("SyncBuilderImpl-Background");
        String path = operationAndData.getData();
        String adjustedPath = this.client.fixForNamespace(path);
        AsyncCallback.VoidCallback voidCallback = new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace2.commit();
                CuratorEventImpl event2 = new CuratorEventImpl(SyncBuilderImpl.this.client, CuratorEventType.SYNC, rc, path, path, ctx, null, null, null, null, null);
                SyncBuilderImpl.this.client.processBackgroundOperation(operationAndData, event2);
            }
        };
        this.client.getZooKeeper().sync(adjustedPath, voidCallback, this.backgrounding.getContext());
    }

    @Override
    public Void forPath(String path) throws Exception {
        OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext());
        this.client.processBackgroundOperation(operationAndData, null);
        return null;
    }
}

