/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import java.io.Closeable;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorWatcher;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.NamespaceWatchedEvent;
import org.apache.storm.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.storm.shade.org.apache.zookeeper.Watcher;

class NamespaceWatcher
implements Watcher,
Closeable {
    private volatile CuratorFrameworkImpl client;
    private volatile Watcher actualWatcher;
    private volatile CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl client, Watcher actualWatcher) {
        this.client = client;
        this.actualWatcher = actualWatcher;
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl client, CuratorWatcher curatorWatcher) {
        this.client = client;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
    }

    @Override
    public void close() {
        this.client = null;
        this.actualWatcher = null;
        this.curatorWatcher = null;
    }

    @Override
    public void process(WatchedEvent event2) {
        if (this.client != null) {
            if (this.actualWatcher != null) {
                this.actualWatcher.process(new NamespaceWatchedEvent(this.client, event2));
            } else if (this.curatorWatcher != null) {
                try {
                    this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, event2));
                }
                catch (Exception e) {
                    this.client.logError("Watcher exception", e);
                }
            }
        }
    }
}

