/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEvent;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;

class Backgrounding {
    private final boolean inBackground;
    private final Object context;
    private final BackgroundCallback callback;

    Backgrounding(Object context2) {
        this.inBackground = true;
        this.context = context2;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback callback) {
        this.inBackground = true;
        this.context = null;
        this.callback = callback;
    }

    Backgrounding(boolean inBackground) {
        this.inBackground = inBackground;
        this.context = null;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback callback, Object context2) {
        this.inBackground = true;
        this.context = context2;
        this.callback = callback;
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Object context2, Executor executor2) {
        this(Backgrounding.wrapCallback(client, callback, executor2), context2);
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Executor executor2) {
        this(Backgrounding.wrapCallback(client, callback, executor2));
    }

    Backgrounding() {
        this.inBackground = false;
        this.context = null;
        this.callback = null;
    }

    boolean inBackground() {
        return this.inBackground;
    }

    Object getContext() {
        return this.context;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    private static BackgroundCallback wrapCallback(final CuratorFrameworkImpl client, final BackgroundCallback callback, final Executor executor2) {
        return new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework dummy, final CuratorEvent event2) throws Exception {
                executor2.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.processResult(client, event2);
                        }
                        catch (Exception e) {
                            if (e instanceof KeeperException) {
                                client.validateConnection(client.codeToState(((KeeperException)e).code()));
                            }
                            client.logError("Background operation result handling threw exception", e);
                        }
                    }
                });
            }
        };
    }
}

