/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import org.apache.storm.shade.org.apache.curator.TimeTrace;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.OperationAndData;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;

class BackgroundSyncImpl
implements BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private final Object context;

    BackgroundSyncImpl(CuratorFrameworkImpl client, Object context2) {
        this.client = client;
        this.context = context2;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace2 = this.client.getZookeeperClient().startTracer("BackgroundSyncImpl");
        this.client.getZooKeeper().sync(operationAndData.getData(), new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace2.commit();
                CuratorEventImpl event2 = new CuratorEventImpl(BackgroundSyncImpl.this.client, CuratorEventType.SYNC, rc, path, null, ctx, null, null, null, null, null);
                BackgroundSyncImpl.this.client.processBackgroundOperation(operationAndData, event2);
            }
        }, this.context);
    }
}

