/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.lang.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "H:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long durationMillis, String format2) {
        return DurationFormatUtils.formatDuration(durationMillis, format2, true);
    }

    public static String formatDuration(long durationMillis, String format2, boolean padWithZeros) {
        Token[] tokens = DurationFormatUtils.lexx(format2);
        int days2 = 0;
        int hours2 = 0;
        int minutes2 = 0;
        int seconds2 = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, d)) {
            days2 = (int)(durationMillis / 86400000L);
            durationMillis -= (long)days2 * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours2 = (int)(durationMillis / 3600000L);
            durationMillis -= (long)hours2 * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes2 = (int)(durationMillis / 60000L);
            durationMillis -= (long)minutes2 * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds2 = (int)(durationMillis / 1000L);
            durationMillis -= (long)seconds2 * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, S)) {
            milliseconds = (int)durationMillis;
        }
        return DurationFormatUtils.format(tokens, 0, 0, days2, hours2, minutes2, seconds2, milliseconds, padWithZeros);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce(duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
                if (tmp.length() != duration.length()) {
                    duration = StringUtils.replaceOnce(tmp, " 0 seconds", "");
                }
            }
            if (duration.length() != 0) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, " 0 days", "");
        }
        duration = " " + duration;
        duration = StringUtils.replaceOnce(duration, " 1 seconds", " 1 second");
        duration = StringUtils.replaceOnce(duration, " 1 minutes", " 1 minute");
        duration = StringUtils.replaceOnce(duration, " 1 hours", " 1 hour");
        duration = StringUtils.replaceOnce(duration, " 1 days", " 1 day");
        return duration.trim();
    }

    public static String formatPeriodISO(long startMillis, long endMillis) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format2) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, format2, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format2, boolean padWithZeros, TimeZone timezone) {
        Token[] tokens = DurationFormatUtils.lexx(format2);
        Calendar start2 = Calendar.getInstance(timezone);
        start2.setTime(new Date(startMillis));
        Calendar end2 = Calendar.getInstance(timezone);
        end2.setTime(new Date(endMillis));
        int milliseconds = end2.get(14) - start2.get(14);
        int seconds2 = end2.get(13) - start2.get(13);
        int minutes2 = end2.get(12) - start2.get(12);
        int hours2 = end2.get(11) - start2.get(11);
        int days2 = end2.get(5) - start2.get(5);
        int months2 = end2.get(2) - start2.get(2);
        int years2 = end2.get(1) - start2.get(1);
        while (milliseconds < 0) {
            milliseconds += 1000;
            --seconds2;
        }
        while (seconds2 < 0) {
            seconds2 += 60;
            --minutes2;
        }
        while (minutes2 < 0) {
            minutes2 += 60;
            --hours2;
        }
        while (hours2 < 0) {
            hours2 += 24;
            --days2;
        }
        if (Token.containsTokenWithValue(tokens, M)) {
            while (days2 < 0) {
                days2 += start2.getActualMaximum(5);
                --months2;
                start2.add(2, 1);
            }
            while (months2 < 0) {
                months2 += 12;
                --years2;
            }
            if (!Token.containsTokenWithValue(tokens, y) && years2 != 0) {
                while (years2 != 0) {
                    months2 += 12 * years2;
                    years2 = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokens, y)) {
                int target = end2.get(1);
                if (months2 < 0) {
                    --target;
                }
                while (start2.get(1) != target) {
                    days2 += start2.getActualMaximum(6) - start2.get(6);
                    if (start2 instanceof GregorianCalendar && start2.get(2) == 1 && start2.get(5) == 29) {
                        ++days2;
                    }
                    start2.add(1, 1);
                    days2 += start2.get(6);
                }
                years2 = 0;
            }
            while (start2.get(2) != end2.get(2)) {
                days2 += start2.getActualMaximum(5);
                start2.add(2, 1);
            }
            months2 = 0;
            while (days2 < 0) {
                days2 += start2.getActualMaximum(5);
                --months2;
                start2.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours2 += 24 * days2;
            days2 = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes2 += 60 * hours2;
            hours2 = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds2 += 60 * minutes2;
            minutes2 = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += 1000 * seconds2;
            seconds2 = 0;
        }
        return DurationFormatUtils.format(tokens, years2, months2, days2, hours2, minutes2, seconds2, milliseconds, padWithZeros);
    }

    static String format(Token[] tokens, int years2, int months2, int days2, int hours2, int minutes2, int seconds2, int milliseconds, boolean padWithZeros) {
        StringBuffer buffer = new StringBuffer();
        boolean lastOutputSeconds = false;
        int sz = tokens.length;
        for (int i = 0; i < sz; ++i) {
            Token token = tokens[i];
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuffer) {
                buffer.append(value.toString());
                continue;
            }
            if (value == y) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(years2), count, '0') : Integer.toString(years2));
                lastOutputSeconds = false;
                continue;
            }
            if (value == M) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(months2), count, '0') : Integer.toString(months2));
                lastOutputSeconds = false;
                continue;
            }
            if (value == d) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(days2), count, '0') : Integer.toString(days2));
                lastOutputSeconds = false;
                continue;
            }
            if (value == H) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(hours2), count, '0') : Integer.toString(hours2));
                lastOutputSeconds = false;
                continue;
            }
            if (value == m) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(minutes2), count, '0') : Integer.toString(minutes2));
                lastOutputSeconds = false;
                continue;
            }
            if (value == s) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(seconds2), count, '0') : Integer.toString(seconds2));
                lastOutputSeconds = true;
                continue;
            }
            if (value != S) continue;
            if (lastOutputSeconds) {
                String str = padWithZeros ? StringUtils.leftPad(Integer.toString(milliseconds), count, '0') : Integer.toString(milliseconds += 1000);
                buffer.append(str.substring(1));
            } else {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString(milliseconds), count, '0') : Integer.toString(milliseconds));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    static Token[] lexx(String format2) {
        char[] array = format2.toCharArray();
        ArrayList<Token> list2 = new ArrayList<Token>(array.length);
        boolean inLiteral = false;
        StringBuffer buffer = null;
        Token previous = null;
        int sz = array.length;
        for (int i = 0; i < sz; ++i) {
            char ch = array[i];
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuffer();
                    list2.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        list2.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue() == value) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list2.add(token);
                previous = token;
            }
            buffer = null;
        }
        return list2.toArray(new Token[list2.size()]);
    }

    static class Token {
        private Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            int sz = tokens.length;
            for (int i = 0; i < sz; ++i) {
                if (tokens[i].getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        Token(Object value, int count) {
            this.value = value;
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuffer) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

