/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.fileupload.disk;

import java.io.File;
import org.apache.storm.shade.org.apache.commons.fileupload.FileItem;
import org.apache.storm.shade.org.apache.commons.fileupload.FileItemFactory;
import org.apache.storm.shade.org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.storm.shade.org.apache.commons.io.FileCleaningTracker;

public class DiskFileItemFactory
implements FileItemFactory {
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    private File repository;
    private int sizeThreshold = 10240;
    private FileCleaningTracker fileCleaningTracker;

    public DiskFileItemFactory() {
        this(10240, null);
    }

    public DiskFileItemFactory(int sizeThreshold, File repository) {
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        DiskFileItem result2 = new DiskFileItem(fieldName, contentType, isFormField, fileName, this.sizeThreshold, this.repository);
        FileCleaningTracker tracker2 = this.getFileCleaningTracker();
        if (tracker2 != null) {
            tracker2.track(result2.getTempFile(), (Object)this);
        }
        return result2;
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    public void setFileCleaningTracker(FileCleaningTracker pTracker) {
        this.fileCleaningTracker = pTracker;
    }
}

