/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.exec.util;

public class DebugUtils {
    public static final String COMMONS_EXEC_LENIENT = "org.apache.storm.shade.org.apache.commons.exec.lenient";
    public static final String COMMONS_EXEC_DEBUG = "org.apache.storm.shade.org.apache.commons.exec.debug";

    public static void handleException(String msg, Exception e) {
        if (DebugUtils.isDebugEnabled()) {
            System.err.println(msg);
            e.printStackTrace();
        }
        if (!DebugUtils.isLenientEnabled()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isDebugEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(COMMONS_EXEC_DEBUG, "false"));
    }

    public static boolean isLenientEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(COMMONS_EXEC_LENIENT, "true"));
    }
}

