/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.exec.OS;
import org.apache.storm.shade.org.apache.commons.exec.environment.DefaultProcessingEnvironment;
import org.apache.storm.shade.org.apache.commons.exec.environment.OpenVmsProcessingEnvironment;

public class EnvironmentUtils {
    private static final DefaultProcessingEnvironment PROCESSING_ENVIRONMENT_IMPLEMENTATION = OS.isFamilyOpenVms() ? new OpenVmsProcessingEnvironment() : new DefaultProcessingEnvironment();

    private EnvironmentUtils() {
    }

    public static String[] toStrings(Map environment) {
        if (environment == null) {
            return null;
        }
        String[] result2 = new String[environment.size()];
        int i = 0;
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result2[i] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++i;
        }
        return result2;
    }

    public static Map getProcEnvironment() throws IOException {
        return PROCESSING_ENVIRONMENT_IMPLEMENTATION.getProcEnvironment();
    }

    public static void addVariableToEnvironment(Map environment, String keyAndValue) {
        String[] parsedVariable = EnvironmentUtils.parseEnvironmentVariable(keyAndValue);
        environment.put(parsedVariable[0], parsedVariable[1]);
    }

    private static String[] parseEnvironmentVariable(String keyAndValue) {
        int index = keyAndValue.indexOf(61);
        if (index == -1) {
            throw new IllegalArgumentException("Environment variable for this platform must contain an equals sign ('=')");
        }
        String[] result2 = new String[]{keyAndValue.substring(0, index), keyAndValue.substring(index + 1)};
        return result2;
    }
}

