/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.twitter.chill.java;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.BitSet;
import org.apache.storm.shade.com.twitter.chill.IKryoRegistrar;
import org.apache.storm.shade.com.twitter.chill.SingleRegistrar;

public class BitSetSerializer
extends Serializer<BitSet> {
    public static IKryoRegistrar registrar() {
        return new SingleRegistrar<BitSet>(BitSet.class, new BitSetSerializer());
    }

    public void write(Kryo kryo, Output output, BitSet bitSet) {
        int n = bitSet.length();
        output.writeInt(n, true);
        for (int i = 0; i < n; ++i) {
            output.writeBoolean(bitSet.get(i));
        }
    }

    public BitSet read(Kryo kryo, Input input, Class<BitSet> clazz) {
        int n = input.readInt(true);
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, input.readBoolean());
        }
        return bitSet;
    }
}

